#!/bin/sh
#
# and example of using mdw to detect if a page has changed
# designed to be ran from cron
#

SUMFILE="sum"
URL="myurl.com"
MDW="mdw"
PROXY="proxy.somewhere.com:8080"

if [  -f ${SUMFILE} ] ; then
	SUM=`cat ${SUMFILE}`

	CMD="${MDW} -u -m -u -p ${PROXY} ${URL} = ${SUM}"
	QCMD="${MDW} -Q -p ${PROXY} ${URL} = ${SUM}"

	if ! ${QCMD} ; then
		echo "${URL} Changed"
		eval "${CMD} > ${SUMFILE}"
	fi

else
	CMD="${MDW} -u -m -u -p ${PROXY} ${URL}"
	QCMD="${MDW} -Q -p ${PROXY} ${URL}"	

	if ! ${QCMD} ; then
		echo "Error Retrieving page"
	else
		eval "${CMD} > ${SUMFILE}"
	fi


fi

