/******************************************************************************
 *  Memory Checker                                                            *
 *  Copyright (C) 2002  Hal Duston                                            *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
 *                                                                            *
 ******************************************************************************/
#ifndef MEMCHECK_H
#define MEMCHECK_H

#undef BEGIN_C_DECL
#undef END_C_DECL
#ifdef __cplusplus
# define BEGIN_C_DECL extern "C" {
# define END_C_DECL }
#else
# define BEGIN_C_DECL
# define END_C_DECL
#endif

#undef PARAMS
#if defined(__STDC__) \
   || defined(_AIX) \
   || (defined(__mips) && defined(_SYSTYPE_SVR4)) \
   || defined(WIN32) \
   || defined(__cplusplus)
# define PARAMS(protos) protos
#else
# define PARAMS(protos) ()
#endif

BEGIN_C_DECL

#ifdef strdup
# undef strdup
#endif
#define strdup(str) \
   memcheck_strdup(__FILE__,__LINE__,NULL,str)
#ifdef malloc
# undef malloc
#endif
#define malloc(size) \
   memcheck_malloc(__FILE__,__LINE__,NULL,size)
#ifdef calloc
# undef calloc
#endif
#define calloc(nmemb,size) \
   memcheck_calloc(__FILE__,__LINE__,NULL,nmemb,size)
#ifdef realloc
# undef realloc
#endif
#define realloc(ptr,size) \
   memcheck_realloc(__FILE__,__LINE__,NULL,ptr,size)
#ifdef free
# undef free
#endif
#define free(ptr) \
   memcheck_free(__FILE__,__LINE__,NULL,ptr)
#ifdef cfree
# undef cfree
#endif
#define cfree(ptr) \
   memcheck_cfree(__FILE__,__LINE__,NULL,ptr) 
#ifdef valloc
# undef valloc
#endif
#define valloc(size) \
   memcheck_valloc(__FILE__,__LINE__,NULL,size)
#ifdef memalign 
# undef memalign
#endif
#define memalign(boundary,size) \
   memcheck_memalign(__FILE__,__LINE__,NULL,boundary,size)
#ifdef posix_memalign
# undef posix_memalign
#endif
#define posix_memalign(memptr,alignment,size) \
   memcheck_posix_align(__FILE__,__LINE__,NULL,memptr,alignment,size)
extern char *memcheck_strdup PARAMS((const char *file,
                                     int line,
                                     const void *addr,
                                     const char *str));
extern void *memcheck_malloc PARAMS((const char *file,
                                     int line,
                                     const void *addr,
                                     size_t size));
extern void *memcheck_calloc PARAMS((const char *file,
                                     int line,
                                     const void *addr,
                                     size_t nmemb,
                                     size_t size));
extern void *memcheck_realloc PARAMS((const char *file,
                                      int line,
                                      const void *addr,
                                      void *ptr,
                                      size_t size));
extern void memcheck_free PARAMS((const char *file,
                                  int line,
                                  const void *addr,
                                  const void *ptr));
extern void memcheck_cfree PARAMS((const char *file,
                                   int line,
                                   const void *addr,
                                   const void *ptr));
extern void *memcheck_valloc PARAMS((const char *file,
                                     int line,
                                     const void *addr,
                                     size_t size));
extern void *memcheck_memalign PARAMS((const char *file,
                                       int line,
                                       const void *addr,
                                       size_t boundary,
                                       size_t size));
extern int memcheck_posix_memalign PARAMS((const char *file,
                                           int line,
                                           void *addr,
                                           void **memptr,
                                           size_t alignment,
                                           size_t size));

END_C_DECL

#endif /* MEMCHECK_H */
