//=============================================================================
// File:       debug.h
// Contents:   Macros for debugging
// Maintainer: Doug Sauder <dwsauder@hunnysoft.com>
// WWW:        http://www.hunnysoft.com/mimepp/
//
// Copyright (c) 1996-2001 Hunny Software, Inc
// All rights reserved.
//
// IN NO EVENT SHALL HUNNY SOFTWARE, INC BE LIABLE TO ANY PARTY FOR DIRECT,
// INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
// THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF HUNNY SOFTWARE,
// INC HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// HUNNY SOFTWARE, INC SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
// BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON
// AN "AS IS" BASIS, AND HUNNY SOFTWARE, INC HAS NO OBLIGATION TO PROVIDE
// MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
//
//=============================================================================

#ifndef DW_DEBUG_H
#define DW_DEBUG_H

#if !defined (DW_DEBUG_VERSION) && !defined (DW_DEVELOPMENT_VERSION)
#define NDEBUG
#endif

#if defined (DW_DEBUG_VERSION)
#define DBG_STMT(x) x;
#else
#define DBG_STMT(x) ;
#endif

#if defined (DW_DEBUG_VERSION) || defined (DW_DEVELOPMENT_VERSION)
#define DEV_STMT(x) x;
#else
#define DEV_STMT(x) ;
#endif

#include <assert.h>

#define DW_ASSERT assert

#endif

