// EmailAddress.cpp

#include <mimepp/mimepp.h>
#include "EmailAddress.h"


EmailAddress::EmailAddress()
{
}


EmailAddress::EmailAddress(const EmailAddress& aAddr)
  : mInetName(aAddr.mInetName),
    mPersonalName(aAddr.mPersonalName),
    mCharset(aAddr.mCharset)
{
}


EmailAddress::EmailAddress(const string& aInetName,
    const string& aPersonalName, const string& aCharset)
  : mInetName(aInetName),
    mPersonalName(aPersonalName),
    mCharset(aCharset)
{
}


EmailAddress::~EmailAddress()
{
}


EmailAddress& EmailAddress::operator = (const EmailAddress& aAddr)
{
    if (this != &aAddr) {
        mInetName     = aAddr.mInetName;
        mPersonalName = aAddr.mPersonalName;
        mCharset      = aAddr.mCharset;
    }
    return *this;
}


void EmailAddress::Set(const string& aInetName, const string& aPersonalName,
    const string& aCharset)
{
    mInetName     = aInetName;
    mPersonalName = aPersonalName;
    mCharset      = aCharset;
}


const string& EmailAddress::InetName() const
{
    return mInetName;
}


const string& EmailAddress::PersonalName() const
{
    return mPersonalName;
}


const string& EmailAddress::Charset() const
{
    return mCharset;
}
