// EmailAddress.h

#ifndef EMAILADDRESS_H
#define EMAILADDRESS_H

#include <string>

using std::string;


class EmailAddress {

public:

    EmailAddress();
    EmailAddress(const EmailAddress&);
    EmailAddress(const string& inetName, const string& personalName,
        const string& charset);
    virtual ~EmailAddress();
    EmailAddress& operator = (const EmailAddress&);

    void Set(const string& inetName, const string& personalName,
        const string& charset);

    const string& InetName() const;
    const string& PersonalName() const;
    const string& Charset() const;

private:    

    string mInetName;
    string mPersonalName;
    string mCharset;

};

#endif

