// EmailAttachList.cpp

#include "EmailAttachList.h"

using namespace std;


EmailAttachmentList::EmailAttachmentList()
{
}


EmailAttachmentList::EmailAttachmentList(const EmailAttachmentList& aList)
{
    _CopyAttachments(aList);
}


EmailAttachmentList::~EmailAttachmentList()
{
    _DeleteAttachments();
}


EmailAttachmentList& EmailAttachmentList::operator = (
    const EmailAttachmentList& aList)
{
    if (this != &aList) {
        _DeleteAttachments();
        _CopyAttachments(aList);
    }
    return *this;
}


void EmailAttachmentList::Add(const EmailAttachment& aAddr)
{
    EmailAttachment* addr = new EmailAttachment(aAddr);
	mAttachments.push_back(addr);
}


int EmailAttachmentList::Count() const
{
    return mAttachments.size();
}


const EmailAttachment& EmailAttachmentList::Get(int aIndex) const
{
    return *mAttachments[aIndex];
}


void EmailAttachmentList::_DeleteAttachments()
{
    vector<EmailAttachment*>::iterator ppaddr = mAttachments.begin();
    while (ppaddr != mAttachments.end()) {
        if (*ppaddr) delete *ppaddr;
        *ppaddr = 0;
        ++ppaddr;
    }
    mAttachments.clear();
}


void EmailAttachmentList::_CopyAttachments(const EmailAttachmentList& aList)
{
    vector<EmailAttachment*>::iterator ppaddr = mAttachments.begin();
    while (ppaddr != mAttachments.end()) {
        EmailAttachment* addr = new EmailAttachment(**ppaddr);
        mAttachments.push_back(addr);
        ++ppaddr;
    }
}
