// EmailAttachList.h

#ifndef EMAIL_ATTACH_LIST_H
#define EMAIL_ATTACH_LIST_H

#include <vector>
#include "EmailAttach.h"


class EmailAttachmentList
{
public:

    EmailAttachmentList();
    EmailAttachmentList(const EmailAttachmentList&);
    virtual ~EmailAttachmentList();

    EmailAttachmentList& operator = (const EmailAttachmentList&);

    void Add(const EmailAttachment& addr);

    int Count() const;
    const EmailAttachment& Get(int index) const;

private:

    std::vector<EmailAttachment*> mAttachments;

    void _DeleteAttachments();
    void _CopyAttachments(const EmailAttachmentList&);
};

#endif
