// EmailText.cpp

#include <mimepp/mimepp.h>
#include "EmailText.h"


EmailText::EmailText()
{
}


EmailText::EmailText(const EmailText& aOther)
  : mText(aOther.mText),
    mCharset(aOther.mCharset)
{
}


EmailText::EmailText(const string& aText, const string& aCharset)
  : mText(aText),
    mCharset(aCharset)
{
}


EmailText::~EmailText()
{
}


EmailText& EmailText::operator = (const EmailText& aOther)
{
    if (this != &aOther) {
        mText = aOther.mText;
        mCharset = aOther.mCharset;
    }
    return *this;
}


void EmailText::Set(const string& aText, const string& aCharset)
{
    mText = aText;
    mCharset = aCharset;
}


const string& EmailText::Text() const
{
    return mText;
}


const string& EmailText::Charset() const
{
    return mCharset;
}
