
#include <string.h>
#include <mingpp.h>

int main()
{
  Ming_init();
  Ming_setScale(1.0);

  /* sprite has one letter per frame */
  SWFSprite *p = new SWFSprite();

  p->add(new SWFAction("stop();"));

  char *chars = "abcdefghijklmnopqrstuvwxyz1234567890!@#$%^&*()_+-=/[]{}|;:,.<>?`~";

  SWFFont *f = new SWFFont("_sans");

  char *letter = strdup("x");
  SWFDisplayItem *i = NULL;

  for(int n=0; n<strlen(chars); ++n)
  {
    letter[0] = chars[n];

    if(i) p->remove(i);

    SWFTextField *t = new SWFTextField();
    t->setFont(f);
    t->setHeight(240);
    t->setBounds(600,240);
    t->align(SWFTEXTFIELD_ALIGN_CENTER);
    t->addString(letter);
    i = p->add(t);
    p->labelFrame(letter);
    p->nextFrame();
  }


  /* hit region for button - the entire frame */

  SWFShape *s = new SWFShape();
  s->setRightFill(s->addSolidFill(0, 0, 0));
  s->drawLine(600, 0);
  s->drawLine(0, 400);
  s->drawLine(-600, 0);
  s->drawLine(0, -400);


  /* button checks for pressed key, sends sprite to the right frame */

  SWFButton *b = new SWFButton();
  b->addShape(s, SWFBUTTON_HIT);

  char action[64];

  for(int n=0; n<strlen(chars); ++n)
  {
    sprintf(action, "setTarget('/char'); gotoFrame('%c');", chars[n]);
    b->addAction(new SWFAction(action), SWFBUTTON_KEYPRESS(chars[n]));
  }

  SWFMovie *m = new SWFMovie();
  m->setDimension(600,400);

  i = m->add(p);
  i->setName("char");
  i->moveTo(0,80);

  m->add(b);

  m->save("test.swf");

  exit(0);
}
