# GladeDialog.py
#
# Moleskine: a source code editor for the GNOME desktop
#
# Copyright (c) 2000 - 2002   Michele Campeotto <micampe@micampe.it>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import os.path

import gnome.ui
import gnome.util
import libglade

class GladeDialog(gnome.ui.GnomeDialog):
    
    """A GnomeDialog window contructed from a Glade file."""
    
    def __init__(self, name):
        """Create a new GladeDialog.
        
        'name' is the name (no path, no extension) of the glade file
        containing the dialog definition and the name of the root widget.
        """
        self.filepath = gnome.util.datadir_file( \
                os.path.join('Moleskine/dialogs', name + '.glade'))
        self.xml = libglade.GladeXML(self.filepath, name)
        dialog = self.xml.get_widget(name)
        gnome.ui.GnomeDialog.__init__(self, _obj = dialog._o)
        dict = {}
        for key in dir(self.__class__):
            dict[key] = getattr(self, key)
        self.xml.signal_autoconnect(dict)
    
    def __getattr__(self, key):
        w = self.xml.get_widget(key)
        if w is None:
            raise AttributeError(_("Widget %s not found") % key)
        self.__dict__[key] = w
        return w
    __getitem__ = __getattr__
