# about.py
#
# Moleskine: a source code editor for the GNOME desktop
#
# Copyright (c) 2000 - 2002   Michele Campeotto <micampe@micampe.it>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

from gnome.ui import GnomeAbout
from gnome.util import datadir_file

translator_str = _('Translator: ')
email_str = _('Translator name <mail@address>')

authors = [
    'Michele Campeotto <micampe@micampe.it>',
    '',
    _('Contributions & help from:'),
    'Tivo Leedjrv <leedjarv@interest.ee>',
    'Adewale Oshineye <aoshineye@digitas.com>',
    'Sourav K. Mandal <Sourav.Mandal@ikaran.com>',
    'Pablo De Napoli <pdenapo@mate.dm.uba.ar>',
    'Matthew Pratt <mattpratt@yahoo.com>',
    '',
    _('Logo by:'),
    'Alberto Doriguzzi Bozzo <lastalba@yahoo.com>']

if translator_str != 'Translator: ' and \
   email_str != 'Translator name <mail@address>':
    authors.extend(['', translator_str, email_str])

description = _("Moleskine is a source code editor for the GNOME desktop.")

def show_infos():
    dialog = GnomeAbout(
        'Moleskine', '0.7.9', '(C) 2000 - 2002 Michele Campeotto',
        authors, description,
        datadir_file('Moleskine/images/moleskine-logo.jpeg'))
    dialog.show()
