/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.gjt.mm.mysql.Connection;

public class Driver
implements java.sql.Driver {
    private Properties _Props;
    static final int _MAJORVERSION = 1;
    static final int _MINORVERSION = 2;
    static final boolean debug = false;
    static final boolean trace = false;

    public synchronized java.sql.Connection connect(String Url, Properties Info) throws SQLException {
        this._Props = this.parseURL(Url, Info);
        if (this._Props == null) {
            return null;
        }
        return new Connection(this.host(), this.port(), this._Props, this.database(), Url, this);
    }

    public synchronized boolean acceptsURL(String Url) throws SQLException {
        return this.parseURL(Url, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String Url, Properties Info) throws SQLException {
        if (this._Props == null) {
            this._Props = new Properties();
        }
        DriverPropertyInfo HostProp = new DriverPropertyInfo("HOST", this._Props.getProperty("HOST"));
        HostProp.required = true;
        HostProp.description = "Hostname of MySQL Server";
        DriverPropertyInfo PortProp = new DriverPropertyInfo("PORT", this._Props.getProperty("PORT", "3306"));
        PortProp.required = false;
        PortProp.description = "Port number of MySQL Server";
        DriverPropertyInfo DBProp = new DriverPropertyInfo("DBNAME", this._Props.getProperty("DBNAME"));
        DBProp.required = false;
        DBProp.description = "Database name";
        DriverPropertyInfo UserProp = new DriverPropertyInfo("user", Info.getProperty("user"));
        UserProp.required = true;
        UserProp.description = "Username to authenticate as";
        DriverPropertyInfo PasswordProp = new DriverPropertyInfo("password", Info.getProperty("password"));
        PasswordProp.required = true;
        PasswordProp.description = "Password to use for authentication";
        DriverPropertyInfo AutoReconnect = new DriverPropertyInfo("autoReconnect", Info.getProperty("autoReconnect", "false"));
        AutoReconnect.required = false;
        AutoReconnect.choices = new String[]{"true", "false"};
        AutoReconnect.description = "Should the driver try to re-establish bad connections?";
        DriverPropertyInfo MaxReconnects = new DriverPropertyInfo("maxReconnects", Info.getProperty("maxReconnects", "3"));
        MaxReconnects.required = false;
        MaxReconnects.description = "Maximum number of reconnects to attempt if autoReconnect is true";
        DriverPropertyInfo InitialTimeout = new DriverPropertyInfo("initialTimeout", Info.getProperty("initialTimeout", "2"));
        InitialTimeout.required = false;
        InitialTimeout.description = "Initial timeout (seconds) to wait between failed connections";
        DriverPropertyInfo[] Dpi = new DriverPropertyInfo[]{HostProp, PortProp, DBProp, UserProp, PasswordProp, AutoReconnect, MaxReconnects, InitialTimeout};
        return Dpi;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 2;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String Url, Properties Defaults) throws SQLException {
        StringTokenizer ST;
        Properties URLProps = new Properties(Defaults);
        int index = Url.indexOf("?");
        if (index != -1) {
            String ParamString = Url.substring(index + 1, Url.length());
            Url = Url.substring(0, index);
            StringTokenizer QueryParams = new StringTokenizer(ParamString, "&");
            while (QueryParams.hasMoreTokens()) {
                StringTokenizer VP = new StringTokenizer(QueryParams.nextToken(), "=");
                String Param = "";
                if (VP.hasMoreTokens()) {
                    Param = VP.nextToken();
                }
                String Value = "";
                if (VP.hasMoreTokens()) {
                    Value = VP.nextToken();
                }
                if (Value.length() <= 0 || Param.length() <= 0) continue;
                ((Hashtable)URLProps).put(Param, Value);
            }
        }
        if (!(ST = new StringTokenizer(Url, ":/", true)).hasMoreTokens()) return null;
        String Protocol = ST.nextToken();
        if (Protocol == null) return null;
        if (!Protocol.toLowerCase().equals("jdbc")) {
            return null;
        }
        if (!ST.hasMoreTokens()) return null;
        String Colon = ST.nextToken();
        if (Colon == null) return null;
        if (!Colon.equals(":")) {
            return null;
        }
        if (!ST.hasMoreTokens()) return null;
        String SubProto = ST.nextToken();
        if (SubProto == null) return null;
        if (!SubProto.toLowerCase().equals("mysql")) {
            return null;
        }
        if (!ST.hasMoreTokens()) return null;
        Colon = ST.nextToken();
        if (Colon == null) return null;
        if (!Colon.equals(":")) {
            return null;
        }
        if (!ST.hasMoreTokens()) return null;
        String Slash = ST.nextToken();
        String Slash2 = "";
        if (ST.hasMoreTokens()) {
            Slash2 = ST.nextToken();
        }
        if (Slash == null || Slash2 == null) return null;
        if (!Slash.equals("/") && !Slash2.equals("/")) {
            return null;
        }
        if (!ST.hasMoreTokens()) return null;
        String Token2 = ST.nextToken();
        if (Token2 == null) return null;
        if (!Token2.equals(":") && !Token2.equals("/")) {
            ((Hashtable)URLProps).put("HOST", Token2);
            if (!ST.hasMoreTokens()) return null;
            Token2 = ST.nextToken();
        }
        if (Token2.equals(":") && ST.hasMoreTokens()) {
            Token2 = ST.nextToken();
            ((Hashtable)URLProps).put("PORT", Token2);
            if (ST.hasMoreTokens()) {
                Token2 = ST.nextToken();
            }
        }
        if (!Token2.equals("/")) return URLProps;
        if (!ST.hasMoreTokens()) return null;
        Token2 = ST.nextToken();
        ((Hashtable)URLProps).put("DBNAME", Token2);
        return URLProps;
    }

    public String host() {
        return this._Props.getProperty("HOST", "localhost");
    }

    public int port() {
        return Integer.parseInt(this._Props.getProperty("PORT", "3306"));
    }

    public String database() {
        return this._Props.getProperty("DBNAME");
    }

    public String property(String Name) {
        return this._Props.getProperty(Name);
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException E) {
            E.printStackTrace();
        }
    }
}

