/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Field;
import org.gjt.mm.mysql.ResultSetMetaData;

public class ResultSet
implements java.sql.ResultSet {
    Vector Rows;
    Field[] Fields;
    int currentRow = -1;
    byte[][] This_Row;
    Connection Conn;
    SQLWarning Warnings;
    boolean wasNullFlag = false;
    boolean reallyResult = false;
    long updateID = -1L;
    long updateCount;
    private static SimpleDateFormat _TSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public boolean next() throws SQLException {
        if (!this.reallyResult()) {
            throw new SQLException("ResultSet is from UPDATE. No Data", "S1000");
        }
        if (this.currentRow + 1 >= this.Rows.size()) {
            return false;
        }
        this.clearWarnings();
        ++this.currentRow;
        this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
        return true;
    }

    public boolean prev() throws SQLException {
        if (this.currentRow - 1 >= 0) {
            --this.currentRow;
            this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
            return true;
        }
        return false;
    }

    public void close() throws SQLException {
        if (this.Rows != null) {
            this.Rows.removeAllElements();
        }
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    public String getString(int columnIndex) throws SQLException {
        if (this.Fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[columnIndex - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return null;
        }
        if (this.Conn != null && this.Conn.useUnicode()) {
            try {
                String Encoding = this.Conn.getEncoding();
                if (Encoding == null) {
                    return new String(this.This_Row[columnIndex - 1]);
                }
                return new String(this.This_Row[columnIndex - 1], this.Conn.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("Unsupported character encoding '" + this.Conn.getEncoding() + "'.", "0S100");
            }
        }
        return new String(this.This_Row[columnIndex - 1]);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        String S = this.getString(columnIndex);
        if (S != null && S.length() > 0) {
            char c = S.toLowerCase().charAt(0);
            return c == 't' || c == 'y' || c == '1';
        }
        return false;
    }

    public byte getByte(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[columnIndex - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return 0;
        }
        Field F = this.Fields[columnIndex - 1];
        switch (F.getMysqlType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                try {
                    String S = this.getString(columnIndex);
                    if (S.indexOf(".") != -1) {
                        S = S.substring(0, S.indexOf("."));
                    }
                    return Byte.parseByte(S);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Value '" + this.getString(columnIndex) + "' is out of range [-127,127]", "S1009");
                }
            }
        }
        return this.This_Row[columnIndex - 1][0];
    }

    public short getShort(int columnIndex) throws SQLException {
        String S = this.getString(columnIndex);
        if (S != null) {
            if (S.length() == 0) {
                return 0;
            }
            try {
                return Short.parseShort(S);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for short '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
            }
        }
        return 0;
    }

    public int getInt(int columnIndex) throws SQLException {
        String S = this.getString(columnIndex);
        if (S != null) {
            if (S.length() == 0) {
                return 0;
            }
            try {
                return Integer.parseInt(S);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for integer '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
            }
        }
        return 0;
    }

    public long getLong(int columnIndex) throws SQLException {
        String S = this.getString(columnIndex);
        if (S != null) {
            if (S.length() == 0) {
                return 0L;
            }
            try {
                return Long.parseLong(S);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for long '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
            }
        }
        return 0L;
    }

    public float getFloat(int columnIndex) throws SQLException {
        String S = this.getString(columnIndex);
        if (S != null) {
            if (S.length() == 0) {
                return 0.0f;
            }
            try {
                return Float.valueOf(S).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for float '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
            }
        }
        return 0.0f;
    }

    public double getDouble(int columnIndex) throws SQLException {
        String S = this.getString(columnIndex);
        if (S != null) {
            if (S.length() == 0) {
                return 0.0;
            }
            try {
                return Double.valueOf(S);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for double '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
            }
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        String S = this.getString(columnIndex);
        if (S != null) {
            BigDecimal Val;
            if (S.length() == 0) {
                BigDecimal Val2 = new BigDecimal(0.0);
                return Val2.setScale(scale);
            }
            try {
                Val = new BigDecimal(S);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for BigDecimal '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
            }
            try {
                return Val.setScale(scale);
            }
            catch (ArithmeticException arithmeticException) {
                throw new SQLException("Bad format for BigDecimal '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
            }
        }
        return null;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[columnIndex - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return null;
        }
        return this.This_Row[columnIndex - 1];
    }

    public Date getDate(int columnIndex) throws SQLException {
        Integer Y = null;
        Integer M = null;
        Integer D = null;
        String S = "";
        try {
            S = this.getString(columnIndex);
            if (S == null) {
                return null;
            }
            if (this.Fields[columnIndex - 1].getMysqlType() == 7) {
                switch (S.length()) {
                    case 8: 
                    case 14: {
                        Y = new Integer(S.substring(0, 4));
                        M = new Integer(S.substring(4, 6));
                        D = new Integer(S.substring(6, 8));
                        return new Date(Y - 1900, M - 1, D);
                    }
                    case 6: 
                    case 10: 
                    case 12: {
                        Y = new Integer(S.substring(0, 2));
                        M = new Integer(S.substring(2, 4));
                        D = new Integer(S.substring(4, 6));
                        return new Date(Y, M - 1, D);
                    }
                    case 4: {
                        Y = new Integer(S.substring(0, 2));
                        M = new Integer(S.substring(2, 4));
                        return new Date(Y, M - 1, 1);
                    }
                    case 2: {
                        Y = new Integer(S.substring(0, 2));
                        return new Date(Y, 0, 1);
                    }
                }
                throw new SQLException("Bad format for Date '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
            }
            if (S.length() < 10) {
                throw new SQLException("Bad format for Date '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
            }
            Y = new Integer(S.substring(0, 4));
            M = new Integer(S.substring(5, 7));
            D = new Integer(S.substring(8, 10));
            return new Date(Y - 1900, M - 1, D);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot convert value '" + S + "' from column " + columnIndex + "(" + this.Fields[columnIndex] + " ) to DATE.", "S1009");
        }
    }

    public Time getTime(int columnIndex) throws SQLException {
        int hr = 0;
        int min = 0;
        int sec = 0;
        try {
            String S = this.getString(columnIndex);
            if (S == null) {
                return null;
            }
            Field F = this.Fields[columnIndex - 1];
            if (F.getMysqlType() == 7) {
                int length = S.length();
                switch (length) {
                    case 12: 
                    case 14: {
                        hr = Integer.parseInt(S.substring(length - 6, length - 4));
                        min = Integer.parseInt(S.substring(length - 4, length - 2));
                        sec = Integer.parseInt(S.substring(length - 2, length));
                        break;
                    }
                    case 10: {
                        hr = Integer.parseInt(S.substring(6, 8));
                        min = Integer.parseInt(S.substring(8, 10));
                        sec = 0;
                        break;
                    }
                    default: {
                        throw new SQLException("Timestamp too small to convert to Time value in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
                    }
                }
                SQLWarning W = new SQLWarning("Precision lost converting TIMESTAMP to Time with getTime() on column " + columnIndex + "(" + this.Fields[columnIndex] + ").");
                if (this.Warnings == null) {
                    this.Warnings = W;
                } else {
                    this.Warnings.setNextWarning(W);
                }
            } else if (F.getMysqlType() == 12) {
                hr = Integer.parseInt(S.substring(11, 13));
                min = Integer.parseInt(S.substring(14, 16));
                sec = Integer.parseInt(S.substring(17, 19));
                SQLWarning W = new SQLWarning("Precision lost converting DATETIME to Time with getTime() on column " + columnIndex + "(" + this.Fields[columnIndex] + ").");
                if (this.Warnings == null) {
                    this.Warnings = W;
                } else {
                    this.Warnings.setNextWarning(W);
                }
            } else {
                if (S.length() != 5 && S.length() != 8) {
                    throw new SQLException("Bad format for Time '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
                }
                hr = Integer.parseInt(S.substring(0, 2));
                min = Integer.parseInt(S.substring(3, 5));
                sec = S.length() == 5 ? 0 : Integer.parseInt(S.substring(6));
            }
            return new Time(hr, min, sec);
        }
        catch (Exception E) {
            throw new SQLException(E.getClass().getName(), "S1009");
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String S = this.getString(columnIndex);
        if (S == null) {
            return null;
        }
        try {
            switch (S.length()) {
                case 19: {
                    try {
                        java.util.Date D = _TSDF.parse(S);
                        return new Timestamp(D.getTime());
                    }
                    catch (ParseException parseException) {
                        throw new SQLException("Bad format for Timestamp '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
                    }
                }
                case 14: {
                    Integer Y = new Integer(S.substring(0, 4));
                    Integer M = new Integer(S.substring(4, 6));
                    Integer D = new Integer(S.substring(6, 8));
                    Integer HR = new Integer(S.substring(8, 10));
                    Integer MI = new Integer(S.substring(10, 12));
                    Integer SE = new Integer(S.substring(12, 14));
                    return new Timestamp(Y - 1900, M - 1, D, HR, MI, SE, 0);
                }
                case 12: {
                    Integer Y = new Integer(S.substring(0, 2));
                    Integer M = new Integer(S.substring(2, 4));
                    Integer D = new Integer(S.substring(4, 6));
                    Integer HR = new Integer(S.substring(6, 8));
                    Integer MI = new Integer(S.substring(8, 10));
                    Integer SE = new Integer(S.substring(10, 12));
                    return new Timestamp(Y, M - 1, D, HR, MI, SE, 0);
                }
                case 10: {
                    Integer Y = new Integer(S.substring(0, 2));
                    Integer M = new Integer(S.substring(2, 4));
                    Integer D = new Integer(S.substring(4, 6));
                    Integer HR = new Integer(S.substring(6, 8));
                    Integer MI = new Integer(S.substring(8, 10));
                    return new Timestamp(Y, M - 1, D, HR, MI, 0, 0);
                }
                case 8: {
                    Integer Y = new Integer(S.substring(0, 4));
                    Integer M = new Integer(S.substring(4, 6));
                    Integer D = new Integer(S.substring(6, 8));
                    return new Timestamp(Y - 1900, M - 1, D, 0, 0, 0, 0);
                }
                case 6: {
                    Integer Y = new Integer(S.substring(0, 2));
                    Integer M = new Integer(S.substring(2, 4));
                    Integer D = new Integer(S.substring(4, 6));
                    return new Timestamp(Y, M - 1, D, 0, 0, 0, 0);
                }
                case 4: {
                    Integer Y = new Integer(S.substring(0, 2));
                    Integer M = new Integer(S.substring(2, 4));
                    return new Timestamp(Y, M - 1, 1, 0, 0, 0, 0);
                }
                case 2: {
                    Integer Y = new Integer(S.substring(0, 2));
                    return new Timestamp(Y, 0, 1, 0, 0, 0, 0);
                }
            }
            throw new SQLException("Bad format for Timestamp '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
        }
        catch (Exception e) {
            throw new SQLException(e.getClass().getName(), "S1009");
        }
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] b = this.getBytes(columnIndex);
        if (b != null) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    public String getString(String ColumnName) throws SQLException {
        return this.getString(this.findColumn(ColumnName));
    }

    public boolean getBoolean(String ColumnName) throws SQLException {
        return this.getBoolean(this.findColumn(ColumnName));
    }

    public byte getByte(String ColumnName) throws SQLException {
        return this.getByte(this.findColumn(ColumnName));
    }

    public short getShort(String ColumnName) throws SQLException {
        return this.getShort(this.findColumn(ColumnName));
    }

    public int getInt(String ColumnName) throws SQLException {
        return this.getInt(this.findColumn(ColumnName));
    }

    public long getLong(String ColumnName) throws SQLException {
        return this.getLong(this.findColumn(ColumnName));
    }

    public float getFloat(String ColumnName) throws SQLException {
        return this.getFloat(this.findColumn(ColumnName));
    }

    public double getDouble(String ColumnName) throws SQLException {
        return this.getDouble(this.findColumn(ColumnName));
    }

    public BigDecimal getBigDecimal(String ColumnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(ColumnName), scale);
    }

    public byte[] getBytes(String ColumnName) throws SQLException {
        return this.getBytes(this.findColumn(ColumnName));
    }

    public Date getDate(String ColumnName) throws SQLException {
        return this.getDate(this.findColumn(ColumnName));
    }

    public Time getTime(String ColumnName) throws SQLException {
        return this.getTime(this.findColumn(ColumnName));
    }

    public Timestamp getTimestamp(String ColumnName) throws SQLException {
        return this.getTimestamp(this.findColumn(ColumnName));
    }

    public InputStream getAsciiStream(String ColumnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(ColumnName));
    }

    public InputStream getUnicodeStream(String ColumnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(ColumnName));
    }

    public InputStream getBinaryStream(String ColumnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(ColumnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.Warnings;
    }

    public void clearWarnings() throws SQLException {
        this.Warnings = null;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned Update not supported.", "S1C00");
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this.Rows, this.Fields);
    }

    public Object getObject(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column index out of range (" + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        Field F = this.Fields[columnIndex - 1];
        if (this.This_Row[columnIndex - 1] == null) {
            this.wasNullFlag = true;
            return null;
        }
        this.wasNullFlag = false;
        switch (F.getSQLType()) {
            case -7: {
                return new Boolean(this.getBoolean(columnIndex));
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                return new Long(this.getLong(columnIndex));
            }
            case 2: 
            case 3: {
                String S = this.getString(columnIndex);
                if (S != null) {
                    BigDecimal Val;
                    if (S.length() == 0) {
                        BigDecimal Val2 = new BigDecimal(0.0);
                        return Val2;
                    }
                    try {
                        Val = new BigDecimal(S);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SQLException("Bad format for BigDecimal '" + S + "' in column " + columnIndex + "(" + this.Fields[columnIndex] + ").", "S1009");
                    }
                    return Val;
                }
                return null;
            }
            case 6: 
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case -1: 
            case 1: 
            case 12: {
                if (F.isBinary()) {
                    return this.getBytes(columnIndex);
                }
                return this.getString(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
        }
        throw new SQLException("Unkown type", "S1009");
    }

    public Object getObject(String ColumnName) throws SQLException {
        return this.getObject(this.findColumn(ColumnName));
    }

    public int findColumn(String ColumnName) throws SQLException {
        int i = 0;
        while (i < this.Fields.length) {
            if (this.Fields[i].Name.equalsIgnoreCase(ColumnName)) {
                return i + 1;
            }
            String FullName = String.valueOf(this.Fields[i].TableName) + "." + this.Fields[i].Name;
            if (FullName.equalsIgnoreCase(ColumnName)) {
                return i + 1;
            }
            ++i;
        }
        throw new SQLException("Column '" + ColumnName + "' not found.", "S0022");
    }

    ResultSet(Field[] Fields, Vector Tuples, Connection Conn) {
        this(Fields, Tuples);
        this.setConnection(Conn);
    }

    ResultSet(Field[] Fields, Vector Tuples) {
        this.currentRow = -1;
        this.Fields = Fields;
        this.Rows = Tuples;
        this.updateCount = this.Rows.size();
        this.reallyResult = true;
        if (this.Rows.size() != 0) {
            this.This_Row = (byte[][])this.Rows.elementAt(0);
            if (this.updateCount == 1L) {
                boolean nulls = true;
                if (this.This_Row == null) {
                    nulls = true;
                } else {
                    int i = 0;
                    while (i < this.This_Row.length) {
                        if (this.This_Row[i] != null) {
                            nulls = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (nulls) {
                    this.currentRow = Tuples.size() + 1;
                }
            }
        } else {
            this.This_Row = null;
        }
    }

    ResultSet(long updateCount, long updateID) {
        this.updateCount = updateCount;
        this.updateID = updateID;
        this.reallyResult = false;
        this.Fields = new Field[0];
    }

    void setConnection(Connection Conn) {
        this.Conn = Conn;
    }

    boolean reallyResult() {
        return this.reallyResult;
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    long getUpdateID() {
        return this.updateID;
    }
}

