##
## handlers.pl
##
## Default nhirc handlers.  Modify this file to your heart's content, as
## long as you make a private copy first.  The code in here is likely to
## look pretty funny, given that it's sorta called out of the butt end 
## of the Net::IRC::Connection package.
##
## This file is part of NetHirc.  (c) 1998-1999 Tony Monroe.
##

push @rcs_id, q$Id: handlers.pl,v 1.11 1999/08/31 05:21:54 tony Exp $;

sub on_connect { 
    my ($self, $event) = @_;
    my (@t);
    push @t, &ircformat('connect0', $self->nick),
	     &ircformat('connect1'),
	     &ircformat('connect2', $stuff{'deity'}, $stuff{'class'});
    &log_n_print($self, @t);
}

sub on_init1 {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    shift @args;
    my $args = join(' ', @args);
    &server_print($self, $args);
}

sub on_init2 { 
    my ($self, $event) = @_;
    my (@args) = $event->args;
    if ($stuff{'firstconnect'}) {
	&on_connect($self, undef);	## Do you smell something?
	$stuff{'firstconnect'} = 0;
    }
    shift @args;
    &server_print($self, @args);
}

sub on_motd {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    shift @args;
    &log_n_print($self, &ircformat('motd', @args));
}

sub on_endofmotd {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    shift @args;
    my $args = join(' ', @args);
    &server_print($self, $args);
    if (@{$stuff{'oldlist'}}) {	
	for my $c (@{$stuff{'oldlist'}}) {
	    &do_join_or_switch($self, 'join', $c);
	}
	delete $stuff{'oldlist'};
    }
}

sub on_nick {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    my ($oldnick) = split(/!/, $event->from);
    my $newnick = $args[0];
    my $nickform;
    if ($oldnick eq $stuff{'oldnick'}) {	## We've been approved!
	delete $stuff{'oldnick'};
	$nickform = 'mynick';
    } else {
	$nickform = 'nick';
    }
    &log_n_print($self, &ircformat($nickform, $oldnick, $newnick));
}

sub on_nicknameinuse { 
    my ($self, $event) = @_;
    $self->nick($stuff{'oldnick'});	## Not approved.
    &prompt($formats{'nicknameinuse'}, [\&on_nicknameinuse_0, $self])
}

sub on_nicknameinuse_0 {
    my ($newnick, $self) = @_;
    $self->nick($newnick);
}

sub on_namreply { 
    my ($self, $event) = @_;
    my (@args) = $event->args;
    my $channel = $args[2];
    my (@namelist) = split(' ', ($event->args)[3]);
    my $sublist;
    my @t;
    if ($channel eq '*') { $channel = "no particular channel"; }
    push @t, &ircformat('names', scalar(@namelist), $channel);
    while (@namelist) {
	$sublist = join(' ', splice(@namelist, 0, 6));
	push @t, &ircformat('namelist', $sublist);
    }
    &log_n_print($self, @t);
}

sub on_cping { 
    my ($self, $event) = @_;
    my @args = $event->args;
    my $nick = $event->nick;
    my $tickle_msg = $formats{tickle};
    &log_n_print($self, &ircformat('ctcp', "PING from $nick: $args"));
    $self->notice($nick, $tickle_msg);
    $self->ctcp_reply($nick, "$args[0] " . time);
    $formats{'tickle'} = &pickrandom(@disasters);
}

sub on_ping {
    my ($self, $event) = @_;
}

sub on_msg { 
    my ($self, $event) = @_;
    my ($args, $nick) = (($event->args), $event->nick);
    &log_n_print($self, &ircformat('priv_from', $nick, $args));
}

sub on_chat { 
    my ($self, $event) = @_;
    my ($nick) = $event->nick;
    my ($to) = $event->to;
    my ($args) = $event->args;
    &log_n_print($self, &ircformat('dchat', $nick, $args));
}

sub on_public { 
    my ($self, $event) = @_;
    my ($nick) = $event->nick;
    my ($to) = $event->to;
    my ($args) = $event->args;
    my $t;
    my $u;
    $u = &ircformat('ochan', $nick, $to, $args);
    if (lc($to) ne lc($stuff{'defchannel'})) {
	$t = $u;
    } else {
	$t = &ircformat('public', $nick, $args);
    }
    $self->print($t);
    if ($stuff{'log'}) { $stuff{'log'}->print("$u\n"); }
}

sub on_join { 
    my ($self, $event) = @_;
    my ($channel) = ($event->to)[0];
    &log_n_print($self, 
		 &ircformat('join', $event->nick, $event->userhost, $channel));
    if ($event->nick eq $self->nick) {	## We tried to join, and it worked.
	&add_channel($channel);
	&set_channel($channel, "new");
    }
}

sub on_part { 
    my ($self, $event) = @_;
    my ($channel) = ($event->to)[0];
    &log_n_print($self, 
		 &ircformat('part', $event->nick, $event->userhost, $channel));
}

sub on_dcc { 
    my ($self, $event) = @_;
    my ($type) = ($event->args)[1];
    my ($nick) = $event->nick;
    
    if (uc($type) eq 'SEND') {
	if (&confirm(&ircformat('admin', 
				"Receive DCC file from $nick? [yn] "), "y")) {
	    $self->new_get($event);
	}
    } elsif (uc($type) eq 'CHAT') {
	if (&confirm(&ircformat('admin', 
				"Commence DCC chat with $nick? [yn] "), "y")) {
	    $self->new_chat($event);
	}
    } else {
	&log_n_print($self, &ircformat('error', 
				"Received unknown DCC type $type from $nick"));
    }
}

sub on_topic {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    my (@from) = split(/!/, $event->from);
    my $hoser = $from[0];
    my @t;
    ## Now this is schizophrenic.  When the topic changes, the
    ## event looks one way, but when the topic is listed when
    ## entering a channel, it looks different.  Fortunately,
    ## we can tell them apart by what "format" they want to use.
    if ($event->format eq "server") { ## Already here.
	push @t, &ircformat('topicpre'), &ircformat('topic', @args[1,2]);
    } elsif ($event->format eq "topic") { ## topic change!
	push @t, &ircformat('topicchange', $hoser), 
		 &ircformat('topic', ($event->to)[0], $args[0]);
    }
    &log_n_print($self, @t);
}

sub on_topicinfo {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, 
		 &ircformat('topicinfo', $args[2], &timeformat($args[3])));
}

sub on_cversion {
    my ($self, $event) = @_;
    my $hoser = $event->nick;
    my $args = join(' ', $event->args);
    my $tickle_msg = $formats{'tickle'};
    &log_n_print($self, &ircformat('ctcp', "VERSION from $hoser: $args"));
    $self->notice($hoser, $tickle_msg);
    $self->ctcp_reply($hoser, "VERSION " . &ircformat('version', $rcs_date));
    $formats{'tickle'} = &pickrandom(@disasters);
}

sub on_nosuchnick {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('nosuchnick', $args[1]));
}

sub on_mode {
    my ($self, $event) = @_;
    my $to = ($event->to)[0];
    my @args = $event->args;
    my $nick = $event->nick;
    my $modestring = $args[0];
    my @modes;
    my @t;
    shift @args;	## Not pop.  Shift.  Dufus.  Pay attention.
    &modesplitter(\@modes, $modestring, @args);
    my $targets = join(' ', @args);
    $targets = " " . $targets if ($targets);	## YAPPH.
    ## Channel-affecting modes are "to" the channel.  (incl. chanops)
    ## Person-affecting modes are "to" the person.  But only the person
    ## sending them actually receives them, so...
    if ($to eq $nick) {	## Personal mode.
	push @t, &ircformat('selfmode', $modestring, $targets);
	for my $k (@modes) {
	    push @t, &ircformat($self_mode_comments{$k->[0]});
	}
    } else { ## Channel mode.
	push @t, &ircformat('channelmode', $to, $nick, $modestring, $targets);
	for my $k (@modes) {
	    push @t, &ircformat($channel_mode_comments{$k->[0]}, $to, $k->[1]);
	}
    }
    &log_n_print($self, @t);
}

sub on_nosuchchannel {
    my ($self, $event) = @_;
    my $channel = ($event->args)[1];
    &log_n_print($self, &ircformat('nosuchchannel', $channel));
}

sub on_channelmodeis {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('channelmodeis', @args[1,2]));
}

sub on_channelcreate {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('channelcreate', $args[1], &timeformat($args[2])));
}

sub on_kick {
    my ($self, $event) = @_;
    my $to = ($event->to)[0];
    my $from = $event->from;
    my @args = $event->args;
    my $fromnick = $from;
    my @formargs;
    my @t;
    $fromnick =~ s/!.*//;
    if ($to eq $self->nick) {	## Ow, that was me!
	if ($fromnick eq $self->nick) {	## Ow, that was my foot kicking me!
	    @formargs = +('selfkick', "You", $args[1], "yourself", $args[0]);
	} else {
	    @formargs = +('kick', $fromnick , $args[1], "you", $args[0]);
	}
	## In either event...
	@{$stuff{'chanlist'}} = grep { $_ ne $args[0] } @{$stuff{'chanlist'}};
	if ($args[0] eq $stuff{'defchannel'}) {
	    if (@{$stuff{'chanlist'}} == 0) {
		push @t, &ircformat('lastchannel'), &ircformat('nochannels');
	    } else {
		$stuff{defchannel} = $stuff{chanlist}->[0];
		push @t, &ircformat('nextchannel', $stuff{'defchannel'});
	    }
	}
    } else { 	## Poor sod, it was someone else.
	if ($fromnick eq $self->nick) {	## Poor sod, that was my foot. :-)
	    @formargs = +('selfkick', "You", $args[1], $to, $args[0]);
	} else {
	    @formargs = +('kick', $fromnick, $args[1], $to, $args[0]);
	}
    }
    push @t, &ircformat(@formargs);
    &log_n_print($self, @t);
}

sub on_caction {
    my ($self, $event) = @_;
    my $from = $event->from;
    my @args = $event->args;
    my $to = ($event->to)[0];
    my $action;
    my ($t, $u);
    shift @args;
    $from =~ s/!.*//;
    $event->dump if $self->{_debug};
    $action = join(' ', @args);
    $u = &ircformat('oaction', $from, $to, $action);
    if (lc($to) ne lc($stuff{defchannel})) {
	$t = $u;
    } else {
	$t = &ircformat('action', $from, $action);
    }
    $self->print($t);
    if ($stuff{'log'}) { $stuff{'log'}->print("$u\n"); }
}

sub on_liststart {
    my ($self, $event) = @_;
    &log_n_print($self, &ircformat('liststart', $event->from));
}

sub on_list {
    my ($self, $event) = @_;
    my $from = $event->from;
    my @args = $event->args;
    shift @args;		## The first one was our name anyway.
    &log_n_print($self, &ircformat('list', @args));	## Channel, users, topic.
}

sub on_listend {
    my ($self, $event) = @_;
    &log_n_print($self, &ircformat('listend', $event->from));
}

sub on_stats {
    my ($self, $event) = @_;
    my @args = $event->args;
    shift @args;		## first arg is our name.
    &log_n_print($self, $self, join(':', @args));
}

sub on_whoisuser {
    my ($self, $event) = @_;
    my @args = $event->args;
    shift @args;
    splice @args, 3, 1;
    &log_n_print($self, &ircformat('whoisuser', @args));
}

sub on_whoisserver {
    my ($self, $event) = @_;
    my @args = $event->args;
    shift @args;
    &log_n_print($self, &ircformat('whoisserver', @args));
}

sub on_whoisoperator {
    my ($self, $event) = @_;	
    my @args = $event->args;
    shift @args;
    &log_n_print($self, &ircformat('whoisoperator', @args));
}

sub on_whoisidle {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('whoisidle', @args[1,2,4], scalar(localtime($args[3]))));
}

sub on_whoischannels {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('whoischannels', @args[1,2]));
};

sub on_n_local {
    my ($self, $event) = @_;
    my @args = $event->args;
    my $from = $event->from;
    &server_print($self, $args[1]);
}

sub on_n_global {
    my ($self, $event) = @_;
    my @args = $event->args;
    my $from = $event->from;
    &server_print($self, $args[1]);
}

sub on_cannotsendtochan {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('cannotsendtochan', $args[1]));
}

sub on_whoreply {
    my ($self, $event) = @_;
    my @args = $event->args;
    ## order of args: channel login host server nick flags ircname
    ##                1       2     3    4      5    6     7
    &log_n_print($self, sprintf($formats{whoreply}, @args[1,5,6,2,3,7]));
}

sub on_disconnect {
    my ($self, $event) = @_;
    ## We've been cut off!
    my $from = $event->from;
    my $reason = ($event->args)[0];
    my @t;
    $stuff{'oldlist'} = $stuff{'chanlist'};	## if we want to reconnect.
    $stuff{'defchannel'} = undef;
    $stuff{'chanlist'} = [];
    push @t, &ircformat('disconnect', $from, $reason), &ircformat('nochannels');
    &log_n_print($self, @t);
}

sub on_leaving {	
    my ($self, $event) = @_;
    my ($args) = $global_quit_message_hack;
#    $event->dump if $self->debug;
    ## One last parting shot...
    unless ($requit_barrier) {
	&log_n_print($self, &ircformat('quit', $self->nick, "i.e. you", $args));
	$requit_barrier = "verboten";
    }
}

sub on_quit {
    my ($self, $event) = @_;	
    my ($args) = $event->args;
    my $from = $event->from;
    my ($fromnick, $fromaddr) = split(/!/, $from);
    ## They're gone.  Sigh.
    &log_n_print($self, &ircformat('quit', $fromnick, $fromaddr, $args));
}

sub on_kill {
    my ($self, $event) = @_;	
    ## Oh man, that's *gotta* hurt!
    my $hoser = (split(/!/, $event->from))[0];
    &log_n_print($self, &ircformat('kill', $hoser));
}

sub on_csource {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my ($args) = $event->args;
    ## ircII doesn't respond to this one.
    &log_n_print($self, &ircformat('ctcp', "SOURCE from $hoser: $args"));
    $self->ctcp_reply($hoser, "SOURCE " . $formats{'source'});
}

sub on_ctime {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my ($args) = $event->args;
    ## ircII sends back scalar localtime, or something like that.
    &log_n_print($self, &ircformat('ctcp', "TIME from $hoser: $args"));
    $self->ctcp_reply($hoser, "TIME " . scalar localtime);
}

sub on_cuserinfo {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my ($args) = $event->args;
    ## ircII sends a mostly-blank thing back.
    &log_n_print($self, &ircformat('ctcp', "USERINFO from $hoser: $args"));
    $self->ctcp_reply($hoser, "USERINFO " . $formats{'userinfo'});
}

sub on_clientinfo {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my ($args) = $event->args;
    ## ircII sends back a list of supported CTCP's.
    &log_n_print($self, &ircformat('ctcp', "CLIENTINFO from $hoser: $args"));
    $self->ctcp_reply($hoser, "CLIENTINFO " . &ircformat('clientinfo', $supported_ctcp));
}

sub on_cfinger {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my ($args) = $event->args;
    ## ircII does a pseudo-finger with real name and idle time.
    &log_n_print($self, &ircformat('ctcp', "FINGER from $hoser: $args"));
    $self->ctcp_reply($hoser, "FINGER " . &ircformat('finger', $userfake, $stuff{'class'}));
}

sub on_crversion {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my $args = join(' ', $event->args);
    ## ircII sends back something vaguely uname-ish and some other cruft.
    &log_n_print($self, &ircformat('ctcp', "VERSION reply from $hoser: $args"));
}

sub on_crsource {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my $args = join(' ', $event->args);
    ## Anybody?
    &log_n_print($self, &ircformat('ctcp', "SOURCE reply from $hoser: $args"));
}

sub on_crtime {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my $args = join(' ', $event->args);
    &log_n_print($self, &ircformat('ctcp', "TIME reply from $hoser: $args"));
}

sub on_cruserinfo {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my $args = join(' ', $event->args);
    &log_n_print($self, &ircformat('ctcp', "USERINFO reply from $hoser: $args"));
}

sub on_crclientinfo {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my $args = join(' ', $event->args);
    &log_n_print($self, &ircformat('ctcp', "CLIENTINFO reply from $hoser: $args"));
}

sub on_crfinger {
    my ($self, $event) = @_;	
    my $hoser = (split(/!/, $event->from))[0];
    my $args = join(' ', $event->args);
    &log_n_print($self, &ircformat('ctcp', "FINGER reply from $hoser: $args"));
}

sub on_crping { 
    my ($self, $event) = @_;
    my @args = $event->args;
    my $hoser = (split(/!/, $event->from))[0];
    my $secs = (split(' ', $args[0]))[1];
    my $delay = $secs - $stuff{'cpings'}->{$hoser};
    &log_n_print($self, &ircformat('ctcp', "PING reply from $hoser: $delay seconds"));
    delete $stuff{'cpings'}->{$hoser};
}

sub on_wasnosuchnick {
    my ($self, $event) = @_;
    my $oopsnick = ($event->args)[1];
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('wasnonick', $from, $oopsnick));
}

sub on_youreoper {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('youreoper', $from, $args[1]));
}

sub on_umodeis {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, &ircformat('umodeis', $args[1]));
}

sub on_whowasuser {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, &ircformat('whowasuser', @args[1,2,3,5]));
}

sub on_adminme {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, &ircformat('adminme', $args[1]));
}

sub on_adminloc1 {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, &ircformat('adminloc', $args[1]));
}

sub on_adminloc2 {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, &ircformat('adminloc', $args[1]));
}

sub on_adminemail {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, &ircformat('adminemail', $args[1]));
}

sub on_inviting {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, &ircformat('inviting', @args[1,2]));
}

sub on_invite {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    my ($from) = $event->from;
    my ($hoser) = (split(/!/, $from))[0];
    &log_n_print($self, &ircformat('invite', $hoser, $args[0]));
}

sub on_traceoper {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, &ircformat('traceoper', @args[2,3]));
}

sub on_traceclass {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, &ircformat('traceclass', @args[2,3]));
}

sub on_banlist {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    &log_n_print($self, &ircformat('banlist', @args[1..3], scalar gmtime $args[4]));
}

sub on_away {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    shift @args;
    &log_n_print($self, &ircformat('away', @args));
}

sub on_links {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    shift @args;
    &log_n_print($self, &ircformat('links', @args));
}

sub on_ison {
    my ($self, $event) = @_;
    my (@args) = $event->args;
    my $t;
    if ($args[1]) {
	$t = &ircformat('ison', $args[1]);
    } else {
	$t = &ircformat('isnton');
    }
    &log_n_print($self, $t);
}

sub on_notexttosend {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('notexttosend', $from, $args[1]));
}

sub on_yourebannedcreep {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    my @t;
    push @t, &ircformat('yourebannedcreep0', $from), 
	     &ircformat('yourebannedcreep1', $args[1]);
    &log_n_print($self, @t);
}

sub on_goof {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('goof', $from, $args[$#args]));
}

sub on_needmoreparams {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('needmoreparams', $args[1]));
}

sub on_userhost {
    my ($self, $event) = @_;
    my @args = $event->args;
    my @t;
    for my $i (split(' ', $args[1])) {
	push @t, &ircformat('userhost', $i);
    }
    &log_n_print($self, @t);
}

sub on_nosuchserver {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('nosuchserver', $args[1]));
}

sub on_unknowncommand {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('goof', $from, $args[2]));
}

sub on_rehashing {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    my $rthingies = join(' ', @args[1..($#args - 1)]);
    &log_n_print($self, &ircformat('rehash', $from, $rthingies));
}

sub on_notice {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = split(/!/, $event->from);
    &log_n_print($self, &ircformat('notice', $from, $args[0]));
}

sub on_wallops {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('wallops', $from, $args[0]));
}

sub on_snotice {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('plain', $args[0]));
}

sub on_toomanychannels {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('toomanychannels'));
}

sub on_useronchannel {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('goof', $from, &ircformat("%X %X %X", @args[1,3,2])));
}

sub on_cantkillserver {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('goof0', $from, $args[$#args]));
}

sub on_notopic {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('notopic', $args[1]));
}

sub on_time {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('servertime', @args[1,2]));
}

sub on_switchaway {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('switchaway', $from, @args));
}

sub on_nickgoof {
    my ($self, $event) = @_;
    my @args = $event->args;
    my ($from) = $event->from;
    &log_n_print($self, &ircformat('goof', $from, $args[$#args]));
    $self->nick($stuff{'oldnick'});
}

sub on_notopic {
    my ($self, $event) = @_;
    my @args = $event->args;
    &log_n_print($self, &ircformat('notopic', $args[1]));
}

sub on_cdcc {
    my ($self, $event) = @_;
}

sub dcc_open {
    my ($self, $event) = @_;	
}

sub dcc_update {
    my ($self, $event) = @_;	
}

sub dcc_close {
    my ($self, $event) = @_;	
}

sub on_ignore { 
    my ($self, $event) = @_;
    ## Wow, this is really exciting!
}

sub on_unknown {
    my ($self, $event) = @_;
    $event->dump;
}

1;
