##
## helpers.pl
##
## Random helper functions for NetHirc.
##
## This file is part of NetHirc.  (c) 1998-1999 Tony Monroe.
##

push @rcs_id, q$Id: helpers.pl,v 1.4 1999/08/24 18:21:51 tony Exp $;

sub yoda_front {
    my @a = split(/([-`!&(){}\[\]<>":;,.?=\\|^\$#_@]+)/, $_[0]);
    my @w;
    my $b;
    for my $segment (@a) {
        @w = split(/(\s+)/, $segment);
        $b .= &yoda(@w);
    }
    return $b;
}

sub yoda {
    my (@words) = @_;
    my ($x, $y);
    my ($iterations);
    $iterations = $#words;
    if (join("", @words) !~ /\S/) {
        return join "", @words;
    }
    for (1..$iterations) {
        while (1) {
            $x = rand($#words + 1);
            last if ($words[$x] =~ /\S/);
        }
        while (1) {
            $y = rand($#words + 1);
            last if ($words[$y] =~ /\S/);
        }
        ($words[$x], $words[$y]) = +($words[$y], $words[$x])
    }
    return join "", @words;
}

sub pigl_front {
    my @a = split(/(\b)/, $_[0]);
    my @b = ();
    for my $i (@a) {
	push @b, &pigl($i);
    }
    return join "", @b;
}

sub pigl {
    my $garply = shift;
    return $garply if ($garply =~ /^(a(nd?|[st])?|t(o|he)|o[frn]|i[fnst]?)$/oi);
    return $garply if ($garply =~ /^(\W|\d|\s)*$/);
    $garply =~ s/^([^a-zA-Z]*)([^aeiouyAEIOUY]*)([a-zA-Z']*)(.*)/$1$3$2ay$4/;
    return $garply;
}

sub mirror {
    my $line = shift;
    my $enil;
    chomp($line);
    while ($line =~ /\t/) {	# untab for effective mirroring.
	my $spaces = " " x (8 - (index($line, "\t") % 8));
	$line =~ s/\t/$spaces/;
    }
    $enil = scalar reverse $line;
    $enil =~ tr,\\/\(\)\[\]{}<>`',/\\\)\(\]\[}{><'`,;
    return $enil;
}


1;
