divert(-1)

# Copyright (c) 2001 Dominic Mitchell.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

divert(0)dnl
########################################################################
# procmail-defn.m4 - definitions for building a procmailrc file.
#
# $Id: procmail-defn.m4,v 1.8 2001/07/11 12:26:50 dom Exp $
########################################################################

`# This procmail.rc was built on' syscmd(date)dnl

divert(-1)

#----------------------------------------------------------------------
# First, the all important m4 definitions.
#----------------------------------------------------------------------

# Select the default folder type and locking method.  If none is
# specified, we default to MBOX.
# I don't think that it's useful to allow a default of JUNK.
ifelse(DFLTTYPE, `MBOX',	`define(`PG_DEFAULT', `$1')',
       DFLTTYPE, `RCVSTORE',	`define(`PG_DEFAULT', `| rcvstore +$1')',
       DFLTTYPE, `MH',		`define(`PG_DEFAULT', `$1/.')',
       DFLTTYPE, `MAILDIR',	`define(`PG_DEFAULT', `$1/')',
				`define(`PG_DEFAULT', `$1')')
ifelse(DFLTTYPE, `MBOX',	`define(`PG_DEFAULTLOCK', `:')',
       DFLTTYPE, `RCVSTORE',	`define(`PG_DEFAULTLOCK', `: $1/.lock')',
       DFLTTYPE, `MH',		`define(`PG_DEFAULTLOCK', `: $1/.lock')',
       DFLTTYPE, `MAILDIR',	`define(`PG_DEFAULTLOCK', `')',
				`define(`PG_DEFAULTLOCK', `:')')

# Select the type of locking needed.
# PG_LOCK(path, type)
define(`PG_LOCK', `ifelse($2, `MBOX',		`:',
			  $2, `RCVSTORE',	`: $1/.lock',
			  $2, `MH',		`: $1/.lock',
			  $2, `MAILDIR',	`',
			  $2, `JUNK',		`',
			  PG_DEFAULTLOCK($1))' )
# Select the folder for output.
# PG_FOLDER(path, type)
define(`PG_FOLDER', `ifelse($2, `MBOX',		`$1',
			    $2, `RCVSTORE',	`| rcvstore +$1',
			    $2, `MH',		`$1/.',
			    $2, `MAILDIR',	`$1/',
			    $2, `JUNK',		`/dev/null',
			    PG_DEFAULT($1))' )

#-----------------------------------------------------------------------
# Literal output.
divert(0)dnl

# Save initial argument for later use.
SAVARG = $1

divert(-1)
#-----------------------------------------------------------------------

# STOPDUPS
define(STOPDUPS,
`:0 Wh: msgid.lock
| formail -D 32768 msgid.cache')


# LIST(listname, folder [, type]) ; foldername w/o the "+".
define(LIST,
`ifdef(`INABLOCK',`	'):0 PG_LOCK($2, $3)
ifdef(`INABLOCK',`	')* (^TO$1|^Return-Path:.*$1)
ifdef(`INABLOCK',`	')PG_FOLDER($2, $3)'
)

# SUBJ(subject, folder [, type]) ; foldername w/o the "+".
define(SUBJ,
`ifdef(`INABLOCK',`	'):0 PG_LOCK($2, $3)
ifdef(`INABLOCK',`	')* ^Subject:.*$1
ifdef(`INABLOCK',`	')PG_FOLDER($2, $3)'
)

# FROM(from, folder [, type]) ; foldername w/o the "+".
define(FROM,
`ifdef(`INABLOCK',`	'):0 PG_LOCK($2, $3)
ifdef(`INABLOCK',`	')* ^(From|Sender):.*$1
ifdef(`INABLOCK',`	')PG_FOLDER($2, $3)'
)

# ARG(arg, folder [, type]) ; foldername w/o the "+".
define(ARG,
`ifdef(`INABLOCK',`	'):0 PG_LOCK($2, $3)
ifdef(`INABLOCK',`	')* `$SAVARG' ?? $1
ifdef(`INABLOCK',`	')PG_FOLDER($2, $3)'
)

# START a blocked section.
define(`START',
`define(`INABLOCK')dnl
:0
* (^TO$1|^Return-Path:.*$1)
{'
)

# END a blocked section
define(`END',
`undefine(`INABLOCK')dnl
}'
)

########################################################################
# End of procmail-defn.m4
########################################################################
divert(0)dnl
