<?php
  /**************************************************************************\
  * phpGroupWare - phpgw_dj                                                  *
  * http://www.phpgroupware.org                                              *
  * Written by Joseph Engo <jengo@phpgroupware.org>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: index.php,v 1.15 2001/05/19 04:59:40 milosch Exp $ */

	$phpgw_info['flags'] = array(
		'enable_nextmatchs_class' => True,
		'enable_categories_class' => True,
		'currentapp'              => 'dj'
	);
	include('../header.inc.php');

	if (! $start)
	{
		$start = 0;
	}

	if ($cat_id)
	{
		$fwhere = ' WHERE ';
		$fand = ' AND ';
		$filtermethod = " song_genre='" . $phpgw->categories->id2name($cat_id) . "'";
	}
	if ($order)
	{
		$ordermethod = " ORDER BY " . $order . " " . $sort;
	}
	else
	{
		$ordermethod = 'ORDER BY song_name';
	}

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('list' => 'index.tpl'));
	$t->set_block('list','index','index');
	$t->set_block('list','row','row');
	$t->set_block('list','footer','footer');

	if ($query)
	{
		$sql = "SELECT COUNT(*) FROM phpgw_dj_songlist WHERE ("
			. "song_name    LIKE '%$query%' OR "
			. "song_title   LIKE '%$query%' OR "
			. "song_artist  LIKE '%$query%' OR "
			. "song_year    LIKE '%$query%' OR "
			. "song_comment LIKE '%$query%' OR "
			. "song_genre   LIKE '%$query%') "
			. $fand
			. $filtermethod;
	}
	else
	{
		$sql = "SELECT COUNT(*) FROM phpgw_dj_songlist" . $fwhere . $filtermethod;
	}

	$phpgw->db->query($sql);
	$phpgw->db->next_record();
	$total = $phpgw->db->f(0);

	if ($total > $phpgw_info['user']['preferences']['common']['maxmatchs'])
	{
		if ($start + $phpgw_info['user']['preferences']['common']['maxmatchs'] > $total)
		{
			$end = $total;
		}
		else
		{
			$end = $start + $phpgw_info['user']['preferences']['common']['maxmatchs'];
		}
		$lang_showing = lang('showing x - x of x',($start + 1),$end,$total);
	}
	else
	{
		$lang_showing = lang('showing x',$total);
	}

	$t->set_var('lang_title',$phpgw->nextmatchs->show_sort_order($sort,"song_title",$order,"/dj/index.php",lang("Title"),'&cat_id='.$cat_id));
	$t->set_var('lang_artist',$phpgw->nextmatchs->show_sort_order($sort,"song_artist",$order,"/dj/index.php",lang('Artist'),'&cat_id='.$cat_id));
	$t->set_var('lang_year',$phpgw->nextmatchs->show_sort_order($sort,"song_year",$order,"/dj/index.php",lang('Year'),'&cat_id='.$cat_id));
	$t->set_var('lang_genre',$phpgw->nextmatchs->show_sort_order($sort,"song_genre",$order,"/dj/index.php",lang('Genre'),'&cat_id='.$cat_id));

	$t->set_var('lang_request',lang('Request'));
	$t->set_var('lang_edit',lang('Edit'));
	$t->set_var('lang_view',lang('View'));
	$t->set_var('lang_download',lang('DL'));

	$t->set_var('lang_showing',$lang_showing);
	$t->set_var('action_url',$phpgw->link('/dj/index.php','cat_id='.$cat_id));
	$t->set_var('cats_link',cat_option($cat_id));

	$t->set_var('next_matchs', $phpgw->nextmatchs->show_tpl("/dj/index.php",$start,$total,
		"&order=$order&filter=$filter&sort=$sort&query=$query&cat_id=$cat_id","80%",
		$phpgw_info["theme"]["th_bg"],0,0,1));

	$t->set_var('start',$start);
	$t->set_var('sort',$sort);
	$t->set_var('order',$order);
	$t->set_var('filter',$filter);
	$t->set_var('query',$query);
	$t->set_var('cat_id',$cat_id);
	$t->set_var('th_bg',$phpgw_info['theme']['th_bg']);
	$t->set_var('lang_request_mult',lang('Add selected to request'));
	$t->set_var('request_mult_link',$phpgw->link('/dj/request.php','start=' . $start . '&cat_id='.$cat_id));
	$t->set_var('lang_show',lang('Manage Shows'));
	$t->set_var('lang_addshow',lang('Add selected to a show'));
	$t->set_var('show_url',$phpgw->link('/dj/show.php'));
	$t->set_var('check',$phpgw_info['server']['app_images'] . SEP . 'check.gif');
	$t->set_var('select_all',lang('Select All'));

	if ($query)
	{
		$sql = "SELECT * FROM phpgw_dj_songlist WHERE ("
			. "song_name    LIKE '%$query%' OR "
			. "song_title  LIKE '%$query%' OR "
			. "song_artist LIKE '%$query%' OR "
			. "song_year LIKE '%$query%' OR "
			. "song_comment LIKE '%$query%' OR "
			. "song_genre LIKE '%$query%') "
			. $fand
			. $filtermethod . " " . $ordermethod . " "
			. $phpgw->db->limit($start);
	}
	else
	{
		$sql = "SELECT * FROM phpgw_dj_songlist " . $fwhere
			. $filtermethod . " " . $ordermethod . " "
			. $phpgw->db->limit($start);
	}

	$phpgw->db->query($sql);

	while ($phpgw->db->next_record())
	{
		if ($phpgw->db->f('song_status') == 'N')
		{
			$unavail = ' (' . lang('unavailable') . ')';
		}
		else
		{
			$unavail = '';
		}
		$id     = $phpgw->db->f('song_id');
		$title  = trim($phpgw->db->f('song_title') . $unavail);
		$artist = trim($phpgw->db->f('song_artist'));
		$year   = trim($phpgw->db->f('song_year'));
		$genre  = trim($phpgw->db->f('song_genre'));

		$t->set_var('id',$id);
		$t->set_var('title',$title);
		$t->set_var('artist',$artist);
		$t->set_var('year',$year);
		$t->set_var('genre',$genre);

		$t->set_var('tr_color',$phpgw->nextmatchs->alternate_row_color());
		$t->set_var('request_link',$phpgw->link('/dj/request.php','song_id=' . $phpgw->db->f('song_id') . '&start=' . $start . '&cat_id='.$cat_id));
		$t->set_var('edit_link',$phpgw->link('/dj/edit.php','song_id=' . $phpgw->db->f('song_id'). '&start=' . $start . '&cat_id=' . $cat_id));
		$t->set_var('view_link',$phpgw->link('/dj/view.php','song_id=' . $phpgw->db->f('song_id'). '&start=' . $start . '&cat_id=' . $cat_id));
		$t->set_var('download_link',$phpgw->link('/dj/download.php','song_id=' . $phpgw->db->f('song_id')));

		$t->set_var('lang_request',lang('Request'));
		$t->set_var('lang_edit',lang('Edit'));
		$t->parse('rows','row',True);
	}

	$t->set_var('requestlist_link','<a href="' . $phpgw->link('/dj/request.php') . '">' . lang('Current request list') . '</a>');
	$t->set_var('lang_import',lang('Import MP3 list'));
	$t->set_var('import_url',$phpgw->link('/dj/import.php'));
	$t->set_var('lang_scan',lang('(re)scan directories'));
	$t->set_var('scan_url',$phpgw->link('/dj/scan.php'));
	//$t->set_var('lang_export',lang("Export ID3 info"));
	//$t->set_var('export_url',$phpgw->link("/dj/export.php"));

	$t->pfp('out','index');
	$t->pfp('out','footer');

	$phpgw->common->phpgw_footer();
?>
