<?php
	/**************************************************************************\
	* phpGroupWare - - eLDAPtir - LDAP Administration                          *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: add.php,v 1.6 2001/05/11 14:24:28 milosch Exp $ */

	$phpgw_info['flags'] = array(
		'enable_nextmatchs_class' => True,
		'currentapp'              => 'eldaptir',
		'parent_page'             => 'viewou.php'
	);
	include('../header.inc.php');

	$servers = servers();
	$ldapobj = CreateObject('eldaptir.ldap',$servers[$server_id]);
	$ldapobj->DEBUG = 1;

	if ($submit && $dn)
	{
		// This doesn't touch LDAP yet, just displays what might occur
		echo "<br>Form values:";
		$thisdn = urldecode($dn);
		$entry  = $ldapobj->read($thisdn);
		while (list($key,$objectclass) = each($entry[0]['objectclass']))
		{
			$object = strtolower($objectclass);
			if($ldapobj->$object)
			{
				echo "<br><br>Checking: ".$object;
				while(list($attrib,$req) = @each($ldapobj->$object))
				{
					$lattrib = strtolower($attrib);		
					if($ldapobj->DEBUG)
					{
						echo "<br>". $object."[".$lattrib."] = "
							. ${$object}[$lattrib];
					}

					if (${$object}[$lattrib] && !$ldapobj->entry[$lattrib])
					{
						$ldapobj->entry[$lattrib] = ${$object}[$lattrib];
					}
				}
			}
		}
		if($ldapobj->DEBUG) { echo "<br><br>Entry values:"; }
		while (list($key,$val) = each($entry[0]))
		{
			if($ldapobj->clean($val))
			{
				if (is_array($val))
				{
					while(list($v) = each($val))
					{
						if($ldapobj->clean($v))
						{
							if($ldapobj->DEBUG) { echo '<br>arr '.$v.': '.$entry[0][$v][0]."\n"; }
						}
					}
				}
				else
				{
					if($ldapobj->DEBUG) { echo '<br>str '.$val.': '.$entry[0][$val][0]."\n"; }
				}
			}
		}
		//$phpgw->common->phpgw_footer();
		//exit;
		//...
		$ldapobj->add($thisdn);
		$phpgw->common->phpgw_footer();
		$phpgw->common->exit();
	}

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_unknowns('remove');
	$t->set_file(array('add' => 'add.tpl'));
	$t->set_block('add','header','header');
	$t->set_block('add','row','row');
	$t->set_block('add','footer','footer');

	$t->set_var('title','<a href="'.$phpgw->link('/eldaptir','server_id='.$server_id).'">'.lang('eldaptir')."</a>\n");
	$t->set_var('th_bg',$phpgw_info['theme']['th_bg']);
	$t->set_var('tr_color1',$phpgw_info['theme']['row_on']);
	$t->set_var('tr_color2',$phpgw_info['theme']['row_off']);
	$t->set_var('lang_cancel',lang('Cancel'));
	$t->set_var('lang_addobj',lang('Add').' '.lang('Objectclass'));
	$t->set_var('lang_submit',lang('Submit'));
	$t->set_var('lang_dn',lang('dn'));
	$t->set_var('lang_obj',lang('Objectclass'));
	$t->set_var('lang_attr',lang('Attribute'));
	$t->set_var('lang_value',lang('Value'));
	$t->set_var('lang_rule',lang('Rule'));
	$t->set_var('action_url',$phpgw->link('/eldaptir/add.php','server_id='.$server_id.'&ou='.$ou));
	//$t->set_var('addobj_url',$phpgw->link('/eldaptir/add.php','ou='.$ou.'&dn='.$dn.'&server_id='.$server_id));
	// following needs to work properly first
	$t->set_var('addobj_url',$phpgw->link('/eldaptir/addobj.php','dn='.$dn));
	$t->set_var('hidden_vars','<input type="hidden" name ="dn" value="'.$dn.'">');
	$t->set_var('cancel_url',$phpgw->link('/eldaptir/viewou.php','ou='.$ou.'&nisMapName='.$nisMapName.'&server_id='.$server_id));

	if ($addobj)
	{
		while(list($key,$oc) = each($ldapobj->objectclasses))
		{
			eval("if \(\$\$oc=='on'\) { \$newoc \.= \$oc\.';'; }");
		}
		$addto = explode(';',$newoc);
		$ldapobj->form_addobj($dn,$addto);
	}

	$userData = $ldapobj->create($ou,$nisMapName);
	$thisdn   = '<input size="30" name="dn" value="'.$ldapobj->objkey.'=,ou='.$ou.','.$ldapobj->base.'">';
	$t->set_var('dn',$thisdn);
	$t->pparse('out','header');

	while (list($key,$objectclass) = each($userData[0]['objectclass']))
	{
		if (gettype($objectclass) == 'string')
		{
			$object = strtolower($objectclass);
			$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
			$t->set_var(tr_color,$tr_color);
			$t->set_var('objectclass',$object);
			$t->set_var('row_name','&nbsp;');
			$t->set_var('row_value','&nbsp;');
			$t->set_var('row_rule','&nbsp;');
			$t->parse('rows','row',True);
			$t->pparse('out','row');
			if (is_array($ldapobj->$object))
			{
				@reset($ldapobj->$object);
				while(list($attrib,$req) = each($ldapobj->$object))
				{
					$lattrib = strtolower($attrib);
					if ($req) { $required = lang('required'); }
					else { $required = lang('optional'); }
					if ($userData[0][$lattrib][0] || $userData[0][$attrib][0])
					{
						if ($userData[0][$attrib])
						{
							$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
							$t->set_var(tr_color,$tr_color);
							$t->set_var('objectclass','&nbsp;');
							$t->set_var('row_name',$attrib);
							$t->set_var('row_value','<input size="30" name="'.$object.'['.$attrib.']" value="'.$userData[0][$attrib][0].'">');
							$t->set_var('row_rule',$required);
							$t->parse('rows','row',True);
						}
						else
						{
							$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
							$t->set_var(tr_color,$tr_color);
							$t->set_var('objectclass','&nbsp;');
							$t->set_var('row_name',$attrib);
							$t->set_var('row_value','<input size="30" name="'.$object.'['.$lattrib.']" value="'.$userData[0][$lattrib][0].'">');
							$t->set_var('row_rule',$required);
							$t->parse('rows','row',True);
						}
					}
					else
					{
						$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
						$t->set_var(tr_color,$tr_color);
						$t->set_var('objectclass','&nbsp;');
						$t->set_var('row_name',$attrib);
						$t->set_var('row_value','<input size="30" name="'.$object.'['.$attrib.']" value="">');
						$t->set_var('row_rule',$required);
						$t->parse('rows','row',True);
					}
					$t->pparse('out','row');
				}
			}
		}
	}

	$t->pparse('out','footer');
	$phpgw->common->phpgw_footer();
?>
