<?php
  /**************************************************************************\
  * phpGroupWare - eLDAPtir LDAP Servers                                     *
  * http://www.phpgroupware.org                                              *
  * Written by Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: servers.php,v 1.5 2001/05/11 14:32:50 milosch Exp $ */

	$phpgw_info["flags"] = array(
		'currentapp' => 'eldaptir',
		'enable_nextmatchs_class' => True);

	include('../header.inc.php');

	if(!$phpgw->acl->check('run',1,'admin'))
	{
		echo lang('access not permitted');
		$phpgw->common->phpgw_footer();
		$phpgw->common->phpgw_exit();

	}

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);

	$t->set_file(array('server_list_t' => 'listservers.tpl'));
	$t->set_block('server_list_t','server_list','list');

	$common_hidden_vars = "<input type=\"hidden\" name=\"sort\" value=\"$sort\">\n"
		. "<input type=\"hidden\" name=\"order\" value=\"$order\">\n"
		. "<input type=\"hidden\" name=\"query\" value=\"$query\">\n"
		. "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
		. "<input type=\"hidden\" name=\"filter\" value=\"$filter\">\n";

	$t->set_var('lang_action',lang('Server List'));
	$t->set_var('add_action',$phpgw->link('/eldaptir/addserver.php'));
	$t->set_var('lang_add',lang('Add'));
	$t->set_var('title_servers',lang('LDAP Servers'));
	$t->set_var('lang_search',lang('Search'));
	$t->set_var('actionurl',$phpgw->link('/eldaptir/servers.php'));
	$t->set_var('lang_done',lang('Done'));
	$t->set_var('doneurl',$phpgw->link('/admin/index.php'));

	if (! $start) { $start = 0; }

	if($phpgw_info["user"]["preferences"]["common"]["maxmatchs"] && $phpgw_info["user"]["preferences"]["common"]["maxmatchs"] > 0)
	{
		$limit = $phpgw_info["user"]["preferences"]["common"]["maxmatchs"];
	}
	else
	{
		$limit = 15;
	}

	if (!$sort) { $sort = "ASC"; }
	if ($order) { $ordermethod = "order by $order $sort "; }
	else { $ordermethod = " order by name asc "; }

	if ($query) {
	$querymethod = " WHERE name like '%$query%' OR basedn like '%$query%'";
	}

	$db2 = $phpgw->db;

	$sql = "SELECT * FROM phpgw_eldaptir_servers $querymethod $ordermethod";
	$db2->query($sql,__LINE__,__FILE__);
	$total_records = $db2->num_rows();
	$phpgw->db->query($sql . " " . $phpgw->db->limit($start,$limit),__LINE__,__FILE__);
	while ($phpgw->db->next_record())
	{
		$servers[] = array(
			'id'         => $phpgw->db->f('id'),
			'name'       => $phpgw->db->f('name'),
			'rootdn'     => $phpgw->db->f('rootdn'),
			'basedn'     => $phpgw->db->f('basedn'),
			'is_default' => $phpgw->db->f('is_default')
		);
	}


//--------------------------------- nextmatch --------------------------------------------

	$left = $phpgw->nextmatchs->left('/eldaptir/servers.php',$start,$total_records);
	$right = $phpgw->nextmatchs->right('/eldaptir/servers.php',$start,$total_records);
	$t->set_var('left',$left);
	$t->set_var('right',$right);

	if ($total_records > $limit)
	{
		$t->set_var('lang_showing',lang("showing x - x of x",($start + 1),($start + $limit),$total_records));
	}
	else
	{
		$t->set_var('lang_showing',lang("showing x",$total_records));
	}

// ------------------------------ end nextmatch ------------------------------------------

//------------------- list header variable template-declarations ------------------------- 

	$t->set_var('th_bg',$phpgw_info["theme"][th_bg]);
	$t->set_var('sort_name',$phpgw->nextmatchs->show_sort_order($sort,'name',$order,'/eldaptir/servers.php',lang('Name')));
	$t->set_var('sort_basedn',$phpgw->nextmatchs->show_sort_order($sort,'basedn',$order,'/eldaptir/servers.php',lang('basedn')));
	$t->set_var('sort_rootdn',$phpgw->nextmatchs->show_sort_order($sort,'rootdn',$order,'/eldaptir/servers.php',lang('rootdn')));
	$t->set_var('lang_default',lang('Default'));
	$t->set_var('lang_edit',lang('Edit'));
	$t->set_var('lang_delete',lang('Delete'));

// -------------------------- end header declaration --------------------------------------

	for ($i=0;$i<count($servers);$i++)
	{
		$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
		$t->set_var(tr_color,$tr_color);
		$server_id = $servers[$i]['id'];
		$is_default = $servers[$i]['is_default'];
		$server_name  = $phpgw->strip_html($servers[$i]['name']);
		$server_basedn = $phpgw->strip_html($servers[$i]['basedn']);
		$server_rootdn = $phpgw->strip_html($servers[$i]['rootdn']);
		if (!$server_basedn) { $server_basedn= '&nbsp;'; }
//-------------------------- template declaration for list records ---------------------------

		$t->set_var(array(
			'server_name'   => $server_name,
			'server_basedn' => $server_basedn,
			'server_rootdn' => $server_rootdn
		));
		if ($is_default)
		{
			$t->set_var('is_default',lang('Yes'));
		}
		else
		{
			$t->set_var('is_default',lang('No'));
		}

		$t->set_var('edit',$phpgw->link('/eldaptir/editserver.php',"server_id=$server_id&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$t->set_var('lang_edit_entry',lang('Edit'));

		$t->set_var('delete',$phpgw->link('/eldaptir/deleteserver.php',"server_id=$server_id&start=$start&query=$query&sort=$sort&order=$order&filter=$filter"));
		$t->set_var('lang_delete_entry',lang('Delete'));
		$t->parse('list','server_list',True);
	}
// ---------------------------- end record declaration -----------------------------------------

	$t->parse('out','server_list_t',True);
	$t->p('out');

	$phpgw->common->phpgw_footer();
?>
