<?php
	/**************************************************************************\
	* phpGroupWare - - eLDAPtir - LDAP Administration                          *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: view.php,v 1.14 2001/05/11 14:25:02 milosch Exp $ */

	if (!$dn)
	{
		$phpgw_info['flags'] = array(
			'nonavbar' => True,
			'noheader' => True
		);
		Header('Location: ' . $phpgw->link('/eldaptir/index.php'));
	}

	$phpgw_info['flags'] = array(
		'enable_nextmatchs_class' => True,
		'currentapp'              => 'eldaptir',
		'parent_page'             => 'viewou.php'
	);
	include('../header.inc.php');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_unknowns('remove');
	$t->set_file(array('view' => 'view.tpl'));
	$t->set_block('view','header','header');
	$t->set_block('view','row','row');
	$t->set_block('view','footer','footer');

	$t->set_var('title','<a href="'.$phpgw->link('/eldaptir','server_id='.$server_id).'">'.lang("eldaptir")."</a>\n");
	$t->set_var('th_bg',$phpgw_info['theme']['th_bg']);
	$t->set_var('tr_color1',$phpgw_info['theme']['row_on']);
	$t->set_var('tr_color2',$phpgw_info['theme']['row_off']);
	$t->set_var('lang_cancel',lang('View ou'));
	$t->set_var('lang_dn',lang('dn'));
	$t->set_var('lang_obj',lang('Objectclass'));
	$t->set_var('lang_attr',lang('Attribute'));
	$t->set_var('lang_value',lang('Value'));
	$t->set_var('lang_rule',lang('Rule'));
	$t->set_var('lang_edit',lang('Edit'));
	$t->set_var('cancel_url',$phpgw->link('/eldaptir/viewou.php','ou='.$ou.'&nisMapName='.$nisMapName.'&server_id='.$server_id));
	$t->set_var('edit_url',$phpgw->link('/eldaptir/edit.php','ou='.$ou.'&dn='.$dn.'&server_id='.$server_id));

	$servers = servers();

	$ldapobj  = CreateObject('eldaptir.ldap',$servers[$server_id]);
	$thisdn   = urldecode($dn);
	$userData = $ldapobj->read($dn);
	$t->set_var('dn',$thisdn);
	$t->pparse('out','header');

	while (list($key,$objectclass) = each($userData[0]['objectclass']))
	{
		if (gettype($objectclass) == 'string')
		{
			$object = strtolower($objectclass);
			$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
			$t->set_var(tr_color,$tr_color);
			$t->set_var('objectclass',$object);
			$t->set_var('row_name','&nbsp;');
			$t->set_var('row_value','&nbsp;');
			$t->set_var('row_rule','&nbsp;');
			$t->parse("rows","row",True);
			$t->pparse('out','row');
			if (is_array($ldapobj->$object))
			{
				while(list($attrib,$req) = each($ldapobj->$object))
				{
					$lattrib = strtolower($attrib);
					if ($req) { $required = lang('required'); }
					else { $required = lang('optional'); }
					if ($userData[0][$lattrib][0] || $userData[0][$attrib][0])
					{
						if ($userData[0][$attrib])
						{
							$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
							$t->set_var(tr_color,$tr_color);
							$t->set_var('objectclass','&nbsp;');
							$t->set_var('row_name',$attrib);
							$t->set_var('row_value',$userData[0][$attrib][0]);
							$t->set_var('row_rule',$required);
							$t->parse("rows","row",True);
						}
						else
						{
							$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
							$t->set_var(tr_color,$tr_color);
							$t->set_var('objectclass','&nbsp;');
							$t->set_var('row_name',$attrib);
							$t->set_var('row_value',$userData[0][$lattrib][0]);
							$t->set_var('row_rule',$required);
							$t->parse("rows","row",True);
						}
					}
					else
					{
						$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
						$t->set_var(tr_color,$tr_color);
						$t->set_var('objectclass','&nbsp;');
						$t->set_var('row_name',$attrib);
						$t->set_var('row_value','['.lang('empty').']');
						$t->set_var('row_rule',$required);
						$t->parse("rows","row",True);
					}
					$t->pparse('out','row');
				}
			}
		}
	}

	$t->pparse('out','footer');
	$phpgw->common->phpgw_footer();
?>
