<?php
  /**************************************************************************\
  * phpGroupWare - eLDAPtir - LDAP Administration                            *
  * http://www.phpgroupware.org                                              *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: viewou.php,v 1.17 2001/05/11 14:14:20 milosch Exp $ */

	$phpgw_info = array();
	$phpgw_info['flags'] = array(
		'currentapp' => 'eldaptir',
		'enable_nextmatchs_class' => True
	);
	include('../header.inc.php');

	$p = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$p->set_file(array('entries' => 'entries.tpl'));
	$p->set_block('entries','list','list');
	$p->set_block('entries','row','row');
	$p->set_block('entries','empty_row','empty_row');

	$servers = servers();
	$ldapobj = CreateObject('eldaptir.ldap',$servers[$server_id]);
	if($ou)
	{
		if($ou == 'Roaming')
		{
			$searchobj = 'ou='.$ou;
			$filterobj = 'nsLIProfileName=*,objectclass=*';
			$andor = 'OR';
			$p->set_var('lang_user_accounts','nsLIProfileName=*');
		}
		else
		{
			$searchobj = 'ou='.$ou;
			$filterobj = 'cn=*,uid=*';
			$andor = 'OR';
			$p->set_var('lang_user_accounts','ou='.$ou);
		}
	}
	elseif($nismapname || $nisMapName)
	{
		if($nismapname)
		{
			$nis = $nismapname;
		}
		elseif($nisMapName)
		{
			$nis = $nisMapName;
		}
		$searchobj = 'nismapname='.$nis;
		$filterobj = 'objectclass=*';
		$andor = 'OR';
		$p->set_var('lang_user_accounts','nisMapName='.$nis);
	}

	$total = $ldapobj->count($searchobj.','.$ldapobj->base,$filterobj,$andor,$query);

	if (! $start)
	{
		$start = 0;
	}

	if($phpgw_info["user"]["preferences"]["common"]["maxmatchs"] &&
		$phpgw_info["user"]["preferences"]["common"]["maxmatchs"] > 0)
	{
		$offset = $phpgw_info["user"]["preferences"]["common"]["maxmatchs"];
	}
	else
	{
		$offset = 15;
	}

	$p->set_var('title','<a href="'.$phpgw->link('/eldaptir','server_id='.$server_id).'">'.lang("eldaptir")."</a>\n");
	$p->set_var('bg_color',$phpgw_info['theme']['bg_color']);
	$p->set_var('th_bg',$phpgw_info['theme']['th_bg']);

	$p->set_var('next_matchs', $phpgw->nextmatchs->show_tpl("/eldaptir/viewou.php",$start,$total,
		"&order=$order&filter=$filter&sort=$sort&query=$query&".$searchobj.'&server_id='.$server_id,"75%",
		$phpgw_info["theme"]["th_bg"],0,0,1));

	$p->set_var('lang_loginid',$phpgw->nextmatchs->show_sort_order($sort,'dn',$order,'/eldaptir/viewou.php',lang('dn'),'&'.$searchobj.'&server_id='.$server_id));
	$p->set_var('lang_lastname',$phpgw->nextmatchs->show_sort_order($sort,'sn',$order,'/eldaptir/viewou.php',lang('sn'),'&'.$searchobj.'&server_id='.$server_id));
	$p->set_var('lang_firstname',$phpgw->nextmatchs->show_sort_order($sort,'cn',$order,'/eldaptir/viewou.php',lang('cn').'/'.lang('givenname'),'&'.$searchobj.'&server_id='.$server_id));

	$p->set_var('lang_edit',lang('Edit'));
	$p->set_var('lang_delete',lang('Delete'));
	$p->set_var('lang_view',lang('View'));

	if ($total> $phpgw_info["user"]["preferences"]["common"]["maxmatchs"]) {
		if ($start + $phpgw_info["user"]["preferences"]["common"]["maxmatchs"] > $total) {
			$end = $total;
		} else {
			$end = $start + $phpgw_info["user"]["preferences"]["common"]["maxmatchs"];
		}
		$lang_showing=lang("showing x - x of x",($start + 1),$end,$total);
	} else {
		$lang_showing=lang("showing x",$total);
	}
	$p->set_var(lang_showing,$lang_showing.' '.lang('in').' ');

	$info = $ldapobj->search($start,$offset,$searchobj.','.$ldapobj->base,$filterobj,'',$andor,$sort,$order,$query);

	if (!count($info))
	{
		$p->set_var('message',lang('No matches found'));
		$p->parse('rows','empty_row',True);
	}
	else
	{
		while (list($null,$entry) = each($info))
		{
			$dn = $entry['dn'];

			$phpgw->nextmatchs->template_alternate_row_color(&$p);

			$p->set_var('row_loginid',$dn);
			if ($entry['givenname'][0])
			{
				$p->set_var('row_firstname',$entry['givenname'][0]);
			}
			elseif($entry['cn'][0])
			{
				$p->set_var('row_firstname',$entry['cn'][0]);
			}
			else
			{
				$p->set_var('row_firstname','&nbsp');
			}
			if ($entry['sn'][0])
			{
				$p->set_var('row_lastname',$entry['sn'][0]);
			}
			else
			{
				$p->set_var('row_lastname','&nbsp');
			}

			$p->set_var('row_edit','<a href="'.$phpgw->link('/eldaptir/edit.php','ou='.$ou.'&dn='
				. urlencode($dn).'&nisMapName='.$nisMapName .'&server_id='.$server_id) . '"> ' . lang('Edit') . ' </a>');

			if ($phpgw_info['user']['userid'] != $entry['uidnumber'])
			{
				$p->set_var('row_delete','<a href="' . $phpgw->link('/eldaptir/delete.php','ou='.$ou.'&dn='
					. urlencode($dn)) . '&server_id='.$server_id . '"> '.lang('Delete').' </a>');
			}
			else
			{
				$p->set_var('row_delete','&nbsp;');
			}

			$p->set_var('row_view','<a href="' . $phpgw->link('/eldaptir/view.php','ou='.$ou.'&dn='
				. urlencode($dn).'&nisMapName='.$nisMapName .'&server_id='.$server_id) . '"> ' . lang('View') . ' </a>');

			$p->parse('rows','row',True);
		}
	}		// End else

	$p->set_var('action_url',$phpgw->link('/eldaptir/add.php','ou='.$ou.'&nisMapName='.$nisMapName.'&server_id='.$server_id));
	$p->set_var('cancel_url',$phpgw->link('/eldaptir/index.php','server_id='.$server_id));
	$p->set_var('accounts_url',$phpgw->link('/eldaptir/viewou.php','server_id='.$server_id));
	$p->set_var('lang_add',lang('add'));
	$p->set_var('lang_cancel',lang('cancel'));
	$p->set_var('lang_search',lang('search'));

	$p->pparse('out','list');

	$phpgw->common->phpgw_footer();
?>
