<?php
  /**************************************************************************\
  * phpGroupWare module (File Manager)                                       *
  * http://www.phpgroupware.org                                              *
  * Written by Dan Kuykendall <dan@kuykendall.org>                           *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

	$phpgw_info['flags'] = array(
		'currentapp'           => 'filemanager',
		'enable_browser_class' => True,
		'enable_vfs_class'     => True,
		'noheader'             => True
	);
	include('../header.inc.php');

	// Converted to use browser class for content header 16/05/2001
	if ($download)
	{
		$phpgw->browser->content_header($fn);
		echo $phpgw->vfs->read($actiondir.$pwd.$fn);
		$phpgw->common->phpgw_exit();
	}
	else
	{
		$phpgw->common->phpgw_header();
	}

	#    filemanager by Lacey Pevey
	#    v0.02 - 1999/12/05 13:46 CST
	#
	#    You are free to use and distribute this code provided this tiny
	#    header is included. No warranties, fitness for purpose, etc. etc.
	#
	#    Please send comments/bugfixes/enhancements to
	#    lpevey@mailhost.tcs.tulane.edu.

	if (isset($exit)) { unset($edit); unset($upload); }
	$phpgw->vfs->verifydir();

	if (empty($currentdir))
	{
		$phpgw->vfs->cd("/");
	}
	else
	{
		$phpgw->vfs->cd($currentdir);
	}

	if (empty($pwd)){ $pwd = "/"; }
	//echo "<BR>first actiondir:" . $actiondir . "<BR>";
	if (empty($actiondir)){ $actiondir = $currentdir; }
	//echo "second actiondir:" . $actiondir . "<BR>";

	if ($action == "upload"){ $phpgw->vfs->mv($userfile,"$actiondir$pwd$userfile_name",True); }

	$file = $actiondir.$pwd.$fn;

//-------------------------------------------------------------------------------------------------
	if ($copy)
	{
		if ($action == "copy")
		{
			$phpgw->vfs->cp($actiondir.$oldname,$actiondir."/".$newname);
		}
		else
		{
?>
    <table align="center" BGCOLOR="<?php echo $phpgw_info["theme"]["table_bg"]; ?>" border="2" cellspacing="0" cellpadding="3">
      <tr>
        <td>
          <form name="copy" method="post" action="<?php echo $phpgw->link('/filemanager/index.php');?>">
            <input type="hidden" name="oldname"   value="<?php echo $pwd.$fn; ?>">
            <input type="hidden" name="action"    value="copy">
            <input type="hidden" name="pwd"       value="<?php echo $pwd; ?>">
            <input type="hidden" name="actiondir" value="<?php echo "$actiondir"; ?>">
			<font  face="Verdana"><small><?php echo lang('Clipboard Contents: x', $fn); ?></small></font><br>
            <input type="submit" name="copy"      value="<?php echo lang("copy_as") ?>">
            <input type="text"   name="newname"   size="56" value="<?php echo $fn; ?>"><br>
            <input type="submit" name="exit"      value="Cancel">
          </form>
        </td>
      </tr>
    </table>
    <br><br>
<?php
		}
	}
//-------------------------------------------------------------------------------------------------
	if ($rename)
	{
		if ($action == "rename")
		{
			$phpgw->vfs->mv("$actiondir$oldname","$actiondir$pwd$newname");
		}
		else
		{
?>
    <table align="center" BGCOLOR="<?php echo $phpgw_info["theme"]["table_bg"]; ?>" border="2" cellspacing="0" cellpadding="3">
      <tr>
        <td>
          <form name="move" method="post" action="<?php echo $phpgw->link('/filemanager/index.php');?>">
            <input type="hidden" name="pwd"       value="<?php echo $pwd; ?>">
            <input type="hidden" name="actiondir" value="<?php echo "$actiondir"; ?>">
			<font  face="Verdana"><small><?php echo lang('Clipboard Contents: x',$fn); ?></small></font><br>
            <input type="submit" name="rename"    value="<?php echo lang("rename_to"); ?>">
            <input type="text"   name="newname" size="56" value="<?php echo $fn; ?>"><br>
            <input type="hidden" name="oldname"   value="<?php echo $pwd.$fn; ?>">
            <input type="hidden" name="action"    value="rename">
            <input type="submit" name="exit"      value="<?php echo lang("cancel"); ?>">
          </form>
        </td>
      </tr>
    </table>
    <br><br>
<?php
		}
	}
//-------------------------------------------------------------------------------------------------
	if ($newfile)
	{
		if (!empty($fn))
		{
			if (!file_exists($file))
			{
				$phpgw->vfs->write($file, "");
				$edit = 1;
			}
			else
			{
				echo "<B><blink>File already exist. Please edit the existing file, or choose a different file name.</blink></B>";
			}
		}
		else
		{
			echo "You must specify a name for the file you wish to create.";
		}
		echo $result;
	}
//-------------------------------------------------------------------------------------------------
	if ($delete)
	{
		if ($action == "delete")
		{
			$phpgw->vfs->rm($file);
		}
		else
		{
?>
    <table align="center" BGCOLOR="<?php echo $phpgw_info["theme"]["table_bg"]; ?>" border="2" cellspacing="0" cellpadding="3">
      <tr>
        <td>
          <form name="delete" method="post" action="<?php echo $phpgw->link('/filemanager/index.php');?>">
			<font face="Verdana"><small><?php echo lang('do_delete x', $fn); ?>?</small></font>
            <input type="submit" name="delete" value="<?php echo lang("yes"); ?>">
            <input type="submit" name="exit"   value="<?php echo lang("no"); ?>">
            <input type="hidden" name="pwd"    value="<?php echo $pwd; ?>">
            <input type="hidden" name="actiondir" value="<?php echo "$actiondir"; ?>">
            <input type="hidden" name="fn"     value="<?php echo $fn; ?>">
            &nbsp;<input type="hidden" name="action" value="delete">
          </form>
        </td>
      </tr>
    </table>
    <br><br>
<?php
		}
	}

//-------------------------------------------------------------------------------------------------
	if (isset($edit))
	{
		if (!(isset($fn)))
		{
			echo "No filename was specified.";
		}
		else
		{
			if ($save)
			{
				if ((isset($file)) && (isset($contents)))
				{
					$contents = stripslashes($contents);
					$phpgw->vfs->write($file, $contents);
				}
				else
				{
					echo "Error saving file to disk";
				}
			}
?>
    <table BGCOLOR="<?php echo $phpgw_info["theme"]["table_bg"]; ?>" border="2" cellspacing="0" cellpadding="3" align="center">
      <tr>
        <td><?php echo lang("current file") . ":" . $fn; ?></td>
      </tr>
      <tr>
        <td align="center">
          <form method="post" action="<?php echo $phpgw->link('/filemanager/index.php');?>">
            <textarea name="contents" cols="100" rows="25"><?php $contents = $phpgw->vfs->read($actiondir."/".$fn); echo $phpgw->strip_html($contents); ?></textarea><br>
            <input type="submit" name="save" value="<?php echo lang("save"); ?>">
            <input type="submit" name="exit" value="<?php echo lang("exit"); ?>">
            <input type="hidden" name="pwd"  value="<?php echo $pwd; ?>">
            <input type="hidden" name="actiondir" value="<?php echo "$actiondir"; ?>">
            <input type="hidden" name="fn"   value="<?php echo $fn; ?>">
            <input type="hidden" name="edit" value="<?php echo lang("edit"); ?>">
          </form>
        </td>
      </tr>
    </table></form><br>
<?php
		}
	}
//-------------------------------------------------------------------------------------------------
// Display user files.
?>
<table align="center" BGCOLOR="<?php echo $phpgw_info["theme"]["table_bg"]; ?>" border="2" cellspacing="0" cellpadding="3">
<?php
	$dirs = $phpgw->vfs->ls();
	$dir_count = count($dirs);
	for ($diridx=0;$diridx<$dir_count;++$diridx)
	{
		$currentdir = $dirs[$diridx]["name"];
		if ($dirs[$diridx]["type"] == "dir")
		{
?>
<tr><td align="center">
<?php
			if ($dirs[$diridx]["name"] == "home")
			{
				if (strtolower(substr($phpgw_info["user"]["userid"],-1,1)) != "s")
				{
					$apos = "'s";
				}
				else
				{
					$apos = "'";
				}
				echo $phpgw_info["user"]["userid"] . $apos?> <?php echo lang("private_files");
			}
			else
			{
				echo $dirs[$diridx]["name"]." ".lang("group_files");
			}
?>
  :</td></tr>
  <tr>
    <td align="center">
      <form method="post" action="<?php echo $phpgw->link('/filemanager/index.php');?>" name="files">
        <font face="Verdana"><small><?php echo lang("files"); ?>:</small></font><br>
        <select name="fn">
<?php
			$files = $phpgw->vfs->ls($phpgw->vfs->pwd().$dirs[$diridx]["name"]);

			if (!empty ($files))
			{
				$file_count = count($files);
				for ($fileidx=0;$fileidx<$file_count;++$fileidx)
				{
					if ($files[$fileidx]["type"] == "file")
					{
						echo "<option value=\"".$files[$fileidx]["name"]."\">".$files[$fileidx]["name"]."\n";
					}
				}
			}
?>
        </select>
        <input type="hidden" name="pwd"       value="<?php echo $pwd; ?>">
        <input type="hidden" name="actiondir" value="<?php echo $phpgw->vfs->pwd().$dirs[$diridx]["name"]; ?>">
        <BR>
        <input type="submit" name="edit"      value="<?php echo lang("edit"); ?>">
        <input type="submit" name="copy"      value="<?php echo lang("copy"); ?>">
        <input type="submit" name="delete"    value="<?php echo lang("delete"); ?>">
        <input type="submit" name="rename"    value="<?php echo lang("rename"); ?>">
        <input type="submit" name="download"  value="<?php echo lang("download"); ?>">
      </form>
    </td>
    <td>
      <form method="post" action="<?php echo $phpgw->link('/filemanager/index.php');?>" name="newfile">
        <input type="hidden" name="pwd"       value="<?php echo $pwd; ?>">
        <input type="hidden" name="actiondir" value="<?php echo $phpgw->vfs->pwd().$dirs[$diridx]["name"]; ?>">
        <font  face="Verdana"><small><?php echo lang("new_file") . ":"; ?></small></font><br>
        <input type="text"   name="fn" size="20" maxlength="100">
        <input type="submit" name="newfile"   value="<?php echo lang("create"); ?>">
      </form>
    </td>
      <td>
      <form method="post" enctype="multipart/form-data" action="<?php echo $phpgw->link('/filemanager/index.php');?>">
        <font  face="Verdana"><small><?php echo lang("file_upload") . ":"; ?></small></font><br>
        <input type="hidden" name="pwd"       value="<?php echo $pwd; ?>">
        <input type="hidden" name="actiondir" value="<?php echo $phpgw->vfs->pwd().$dirs[$diridx]["name"]; ?>">
        <input type="hidden" name="action"    value="upload">
        <input type="file"   name="userfile"  size="40">
        <input type="submit" name="upload"    value="<?php echo lang("Upload"); ?>">
      </form>
    </td>
  </tr>
<?php
		}//end the if
	}
//}

//-------------------------------------------------------------------------------------------------
// Close table.
?>
</table>
<br>
<br>
<?php
	$phpgw->common->phpgw_footer();
?>
