<?php
  /**************************************************************************\
  * phpGroupWare - Inventory                                                 *
  * http://www.phpgroupware.org                                              *
  * Written by Joseph Engo <jengo@phpgroupware.org>                          *
  *            Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: addproduct.php,v 1.56 2001/05/10 22:08:56 bettina Exp $ */

    $phpgw_info['flags']['currentapp'] = 'inv';
    include('../header.inc.php');

    if (!$submit)
    {
	$referer = $HTTP_REFERER;
    }

    $hidden_vars = "<input type=\"hidden\" name=\"sort\" value=\"$sort\">\n"
                . "<input type=\"hidden\" name=\"order\" value=\"$order\">\n"
                . "<input type=\"hidden\" name=\"query\" value=\"$query\">\n"
                . "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
                . "<input type=\"hidden\" name=\"filter\" value=\"$filter\">\n"
                . "<input type=\"hidden\" name=\"referer\" value=\"$referer\">\n";

    $t = new Template(PHPGW_APP_TPL);
    $t->set_file(array('form' => 'product_form.tpl'));
    $t->set_block('form','add','addhandle');
    $t->set_block('form','edit','edithandle');

    if ($submit)
    {

	if ($choose)
	{
	    $id = create_productid($category);
	}
	else
	{
	    $id = addslashes($id);
	}

	$errorcount = 0;

	if (!$id)
	{
            $error[$errorcount++] = lang('Please enter an ID for that product !');
	}

	if (!$serial)
	{
	    if ($short_name)
	    {
		$phpgw->db->query("select count(*) from phpgw_inv_products where name='$short_name' AND category='$category'");                                                                                                
		$phpgw->db->next_record();

		if ($phpgw->db->f(0) != 0)
		{
		    $error[$errorcount++] = lang('That product name has been used already !');
		}
	    }

	    if ($id)
	    {
		$phpgw->db->query("select count(*) from phpgw_inv_products where id='$id' AND category='$category'");
		$phpgw->db->next_record();

		if ($phpgw->db->f(0) != 0)
		{
		    $error[$errorcount++] = lang('That Product ID has been used already !');
		}
	    }
	}
	else
	{
	    $serial = addslashes($serial);
	}

	if (checkdate($pmonth,$pday,$pyear))
	{
	    $pdate = mktime(2,0,0,$pmonth,$pday,$pyear);
	}
	else
	{
	    if ($pmonth && $pday && $pyear)
	    {
		$error[$errorcount++] = lang('You have entered an invalid purchase date !');
	    }
	}

	if (checkdate($smonth,$sday,$syear))
	{
	    $sdate = mktime(2,0,0,$smonth,$sday,$syear);
	}
	else
	{
    	    if ($smonth && $sday && $syear)
	    {
		$error[$errorcount++] = lang('You have entered an invalid selling date !');
	    }
	}

	if (! $error)
	{
	    $short_name   = addslashes($short_name);
	    $descr  = addslashes($descr);
	    if ($url == 'http://')
	    {
		$url = '';
	    }
	    $url = addslashes($url);
	    if ($ftp == 'ftp://')
	    {
		$ftp = '';
	    }
	    $ftp = addslashes($ftp);

	    $taxpercent = select_tax($category);
	    $retail = round($price*(1+$taxpercent),2);
     
	    $phpgw->db->query("insert into phpgw_inv_products (id,serial,name,descr,category,status,cost,price,"
			      . "retail,stock,mstock,url,ftp,dist,pdate,sdate) values ('$id','$serial','$short_name','$descr','$category','$status','"
			      . "$cost','$price','$retail','$stock','$mstock','$url','$ftp','$dist','$pdate','$sdate')");
    	}
    }

    if ($errorcount)
    {
	$t->set_var('message',$phpgw->common->error_list($error));
    }
    if (($submit) && (! $error) && (! $errorcount))
    {
	$t->set_var('message',lang('Product x x has been added !',$id,$short_name));
    }
    if ((! $submit) && (! $error) && (! $errorcount))
    {
	$t->set_var('message','');
    }

    $t->set_var('lang_choose',lang('Generate Product ID ?'));
    $t->set_var('choose','<input type="checkbox" name="choose" value="True">');

    $t->set_var('id',$id);
    $t->set_var('short_name',$short_name);
    $t->set_var('serial',$serial);
    $t->set_var('descr',$descr);
    $t->set_var('pdate',$pdate);
    $t->set_var('sdate',$sdate);

    if (! ereg('http://',$url))
    {
	$url = 'http://'. $url;
    }
    $t->set_var('url',$url);

    if (! ereg('ftp://',$ftp))
    {
	$ftp = 'ftp://'. $ftp;
    }
    $t->set_var('ftp',$ftp);

    $t->set_var('cost',$cost);
    $t->set_var('price',$price);
    $t->set_var('retail',$retail);
    $t->set_var('stock',$stock);
    $t->set_var('mstock',$mstock);

    if (isset($phpgw_info['user']['preferences']['common']['currency']))
    {
	$currency = $phpgw_info['user']['preferences']['common']['currency'];
	$t->set_var('error','');
    }
    else
    {
	$t->set_var('error',lang('Please select your currency in preferences !'));
    }

    $t->set_var('hidden_vars',$hidden_vars);
    $t->set_var('lang_action',lang('Add product'));
    $t->set_var('actionurl',$phpgw->link('/inv/addproduct.php'));
    $t->set_var('lang_id',lang('Product ID'));
    $t->set_var('lang_short_name',lang('Short Name'));
    $t->set_var('lang_url',lang('WWW'));
    $t->set_var('lang_ftp',lang('FTP'));
    $t->set_var('lang_purchase_date',lang('Purchase date'));
    $t->set_var('lang_selling_date',lang('Selling date'));
    $t->set_var('lang_description',lang('Description'));
    $t->set_var('lang_category',lang('Category'));
    $t->set_var('lang_in_stock',lang('in Stock'));
    $t->set_var('lang_min_stock',lang('min Stock'));
    $t->set_var('lang_cost',lang('Purchase price'));
    $t->set_var('lang_price',lang('Selling price'));
    $t->set_var('lang_retail',lang('Retail'));
    $t->set_var('lang_status',lang('Status'));
    $t->set_var('lang_serial',lang('Serial number'));
    $t->set_var('lang_select_dist',lang('Select distributor'));
    $t->set_var('lang_distributor',lang('Distributor'));

    $t->set_var('status_list',select_status_list($status));

    $d = CreateObject('phpgwapi.contacts');
    $t->set_var('dist_list',select_dist_list($dist));

    $t->set_var('currency',$currency);

    $c = CreateObject('phpgwapi.categories');
    if ($cat_id)
    {
	$t->set_var('category_list',$c->formated_list('select','all',$cat_id,False));
    }
    else
    {
	$t->set_var('category_list',$c->formated_list('select','all',$category,False));
    }

    $undefined = $t->get_undefined('form');
    while ($undef = each($undefined)) {	$t->set_var($undef[0],''); }

    $sm = CreateObject('phpgwapi.sbox');

    if (!$pdate)
    {
	$pmonth = date('m',time());
	$pday = date('d',time());
	$pyear = date('Y',time());
    }
    else
    {
        $pmonth = date('m',$pdate);
        $pday = date('d',$pdate);
        $pyear = date('Y',$pdate);
    }

    $t->set_var('purchase_date_select',$phpgw->common->dateformatorder($sm->getYears('pyear',$pyear),$sm->getMonthText('pmonth',$pmonth),$sm->getDays('pday',$pday)));

    if (!$sdate)
    {
	$smonth = 0;
	$sday = 0;
	$syear = 0;
    }
    else
    {
        $smonth = date('m',$sdate);
        $sday = date('d',$sdate);
        $syear = date('Y',$sdate);
    }

    $t->set_var('selling_date_select',$phpgw->common->dateformatorder($sm->getYears('syear',$syear),$sm->getMonthText('smonth',$smonth),$sm->getDays('sday',$sday)));

    $t->set_var('lang_add',lang('Add'));
    $t->set_var('lang_reset',lang('Clear Form'));
    $t->set_var('done_action',$referer);
    $t->set_var('lang_done',lang('Done'));

    $t->set_var('edithandle','');
    $t->set_var('addhandle','');

    $t->pparse('out','form');
    $t->pparse('addhandle','add');

    $phpgw->common->phpgw_footer();
?>
