<?php
  /**************************************************************************\
  * phpGroupWare - Inventory                                                 *
  * http://www.phpgroupware.org                                              *
  * Written by Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: index.php,v 1.46 2001/05/10 22:08:57 bettina Exp $ */
  
    $phpgw_info['flags'] = array('currentapp' => 'inv',
		    'enable_nextmatchs_class' => True);

    include('../header.inc.php');

    $inventory = CreateObject('inv.inventory');

    $t = new Template(PHPGW_APP_TPL);
    $t->set_file(array('cat_list_t' => 'listcategorys.tpl',                                                                                                                
                     'cat_list'   => 'listcategorys.tpl'));
    $t->set_block('cat_list_t','cat_list','list');

    $c = CreateObject('phpgwapi.categories');
    $grants = $phpgw->acl->get_grants('inv');

    $common_hidden_vars = "<input type=\"hidden\" name=\"sort\" value=\"$sort\">\n"
			. "<input type=\"hidden\" name=\"order\" value=\"$order\">\n"
			. "<input type=\"hidden\" name=\"query\" value=\"$query\">\n"
			. "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
			. "<input type=\"hidden\" name=\"filter\" value=\"$filter\">\n";


    $t->set_var('lang_action',lang('Category list'));
    $t->set_var('add_action',$phpgw->link('/inv/addcategory.php'));
    $t->set_var('lang_add',lang('Add'));
    $t->set_var('lang_search',lang('Search'));
    $t->set_var('actionurl',$phpgw->link('/inv/index.php'));

    if (! $start) { $start = 0; }

    if($phpgw_info['user']['preferences']['common']['maxmatchs'] && $phpgw_info['user']['preferences']['common']['maxmatchs'] > 0) {
                $limit = $phpgw_info['user']['preferences']['common']['maxmatchs'];
    }
    else { $limit = 15; }

    $cats = $c->return_array($type,$start,$limit,$query,$sort,$order);

//--------------------------------- nextmatch --------------------------------------------

    $left = $phpgw->nextmatchs->left('/inv/index.php',$start,$c->total_records);
    $right = $phpgw->nextmatchs->right('/inv/index.php',$start,$c->total_records);
    $t->set_var('left',$left);
    $t->set_var('right',$right);

    if ($query) {
        if ($c->total_records == 0) {  $t->set_var('lang_showing',lang('Your search has returned no matchs !')); }
        else { $t->set_var('lang_showing',lang("showing x",$c->total_records)); }
    }
    else {
	if ($c->total_records > $limit) { $t->set_var('lang_showing',lang('showing x - x of x',($start + 1),($start + $limit),$c->total_records)); }
	else { $t->set_var('lang_showing',lang('showing x',$c->total_records)); }
    }

// ------------------------------ end nextmatch ------------------------------------------

//------------------- list header variable template-declarations -------------------------

    $t->set_var('th_bg',$phpgw_info["theme"][th_bg]);
    $t->set_var('sort_name',$phpgw->nextmatchs->show_sort_order($sort,'cat_name',$order,'/inv/index.php',lang('Name')));
    $t->set_var('sort_number',$phpgw->nextmatchs->show_sort_order($sort,'cat_data',$order,'/inv/index.php',lang('Category ID')));
    $t->set_var('sort_description',$phpgw->nextmatchs->show_sort_order($sort,'cat_description',$order,'/inv/index.php',lang('Description')));
    $t->set_var('sort_tax',$phpgw->nextmatchs->show_sort_order($sort,'cat_data',order,'/inv/index.php',lang('tax')));
    $t->set_var('lang_products',lang('Products'));
    $t->set_var('lang_edit',lang('Edit'));
    $t->set_var('lang_delete',lang('Delete'));
  
// -------------------------- end header declaration --------------------------------------

    for ($i=0;$i<count($cats);$i++) {

    $tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
    $t->set_var('tr_color',$tr_color);

    $data = unserialize($cats[$i]['data']);
    $number = $phpgw->strip_html($data['number']);
    if (! $number) { $number  = '&nbsp;'; }
    $tax = sprintf("%01.2f",(float)$data['tax']);
    if (! $tax) { $tax  = '&nbsp;'; }
    $cat_id = $cats[$i]['id'];
    $owner = $cats[$i]['owner'];
    $level = $cats[$i]['level'];
    $space = '&nbsp;&nbsp;';

    if ($level > 0) { 
        $spaceset = str_repeat($space,$level);
	$name = $spaceset . $phpgw->strip_html($cats[$i]['name']);
    }

    $descr = $phpgw->strip_html($cats[$i]['description']);
    if (! $descr) { $descr  = '&nbsp;'; }

    if ($level == 0) {
	$name = '<font color=FF0000><b>' . $phpgw->strip_html($cats[$i]['name']) . '</b></font>';
	$number = '<font color=FF0000><b>' . $number . '</b></font>';
	$descr = '<font color=FF0000><b>' . $descr . '</b></font>'; 
	$tax = '<font color=FF0000><b>' . $tax . '</b></font>';
    }

//-------------------------- template declaration for list records ---------------------------                                                                                                               
                                                                                                                                                            
    $t->set_var(array('name' => $name,                                                                                                                        
                      'number' => $number,
                      'descr' => $descr,                                                                                                           
                      'tax' => $tax));                                                                                                                
    

    $t->set_var('products',$phpgw->link('/inv/listproducts.php',"filter=$cat_id"));

    if ($inventory->check_perms($grants[$owner],PHPGW_ACL_EDIT) || $owner == $phpgw_info['user']['account_id']) {
    $t->set_var('edit',$phpgw->link('/inv/editcategory.php',"cat_id=$cat_id"));
    $t->set_var('lang_edit_entry',lang('Edit'));
    }
    else {
    $t->set_var('edit','');
    $t->set_var('lang_edit_entry','&nbsp;');
    }
    if ($inventory->check_perms($grants[$owner],PHPGW_ACL_DELETE) || $owner == $phpgw_info['user']['account_id']) {
    $t->set_var('delete',$phpgw->link('/inv/deletecategory.php',"cat_id=$cat_id"));
    $t->set_var('lang_delete_entry',lang('Delete'));         
    }
    else {
    $t->set_var('delete','');
    $t->set_var('lang_delete_entry','&nbsp;');
    }
    $t->parse('list','cat_list',True);
    }
// ---------------------------- end record declaration -----------------------------------------

    $t->parse('out','cat_list_t',True);                                                                                                           
    $t->p('out');

    $phpgw->common->phpgw_footer(); 
?>