<?
  /**************************************************************************\
  * phpGroupWare Application (Napster)                                       *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * Based on WebNap Client copyright 2000                                    *
  * Written by Aakash Kambuj <aakash@idearing.com>                           *
  *            Kalpak Kothari <kalpak@idearing.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  * --------------------------------------------                             *
  * Napster is a registered trademark of Napster Inc  http://www.napster.com *
  * --------------------------------------------                             *
  * INFO:                                                                    *
  * Returns Browser information                                              *
  * based on HTTP_USER_AGENT                                                 *
  *                                                                          *
  * Variables:                                                               *
  * $bd->BROWSER         // Netscape, MSIE, Opera                            *
  * $bd->PLATFORM        // Win,Mac,Unix                                     *
  * $bd->VERSION         // MajorVersion.MinorVersion                        *
  * $bd->MAJORVER        // Major Version (before . in version string)       *
  * $bd->MINORVER        // Minor Version (after . in version string)        *
  \**************************************************************************/

class BrowserDetector { 
  var $UA         =  "";
  var $BROWSER    =  "Unknown";
  var $PLATFORM   =  "Unknown";
  var $VERSION    =  "";
  var $MAJORVER   =  "";
  var $MINORVER   =  "";
  
  function BrowserDetector() { 
    $this->UA = getenv("HTTP_USER_AGENT");
    $preparens = "";
    $parens = "";
    $postparens = "";
    $i = strpos($this->UA,"(");
    if ($i >= 0) {
      $preparens = trim(substr($this->UA,0,$i));
      $parensTMP = substr($this->UA,$i+1,strlen($this->UA));
      $j = strpos($parensTMP,")");
      if($j>=0) {
	$parens = substr($parensTMP,0,$j);
	$postparens = trim(substr($parensTMP,$j+1,strlen($parensTMP)));
      }
    } else $preparens = $this->UA;
    $browVer = $preparens;
    $token = trim(strtok($parens,";"));
    while($token){
      if($token=="compatible") {  
      }
      elseif(eregi("MSIE","$token")) {
	$browVer = $token;
      }
      elseif(eregi("Opera","$token")) {
	$browVer = $token;
      }
      elseif(eregi("X11","$token") || eregi("SunOS","$token") || eregi("Linux","$token")) {
	$this->PLATFORM   =  "Unix";
      }
      elseif(eregi("Win","$token")) {
	$this->PLATFORM   =  $token;
      }
      elseif(eregi("Mac","$token") || eregi("PPC","$token")) {
	$this->PLATFORM   =  $token;
      }
      $token = strtok(";");
    }
    $msieIndex  =  strpos($browVer,"MSIE");
    if($msieIndex >= 0) $browVer =  substr($browVer,$msieIndex,strlen($browVer));
    $leftover   =  "";
    if(substr($browVer,0,strlen("Mozilla")) == "Mozilla") {
      $this->BROWSER =  "Netscape";
      $leftover=substr($browVer,strlen("Mozilla")+1,strlen($browVer));
    }
    elseif(substr($browVer,0,strlen("Lynx")) == "Lynx") {
      $this->BROWSER =  "Lynx";
      $leftover=substr($browVer,strlen("Lynx")+1,strlen($browVer));
    }
    elseif(substr($browVer,0,strlen("MSIE")) == "MSIE") {
      $this->BROWSER =  "IE";
      $leftover=substr($browVer,strlen("MSIE")+1,strlen($browVer));
    }
    elseif(substr($browVer,0,strlen("Microsoft Internet Explorer")) == "Microsoft Internet Explorer") {
      $this->BROWSER =  "IE";
      $leftover=substr($browVer,strlen("Microsoft Internet Explorer")+1,strlen($browVer));
    }
    elseif(substr($browVer,0,strlen("Opera")) == "Opera") {
      $this->BROWSER =  "Opera";
      $leftover=substr($browVer,strlen("Opera")+1,strlen($browVer));
    }
    $leftover = trim($leftover);
    /* CHECK FOR OPERA BROWSERS BELOW VERSION 4.0 */
    if(!empty($postparens)) {
      if(substr($postparens,0,strlen("Opera")) == "Opera") {
	$this->BROWSER = "Opera";
	$v  = trim(substr($postparens,strlen("Opera")+1,strlen($postparens)));
	$v  = trim(substr($v,0,strpos($v," ")));
	$leftover = $v;
      }
    }
    $i=strpos($leftover," ");
    if($i > 0)
      $this->VERSION = substr($leftover,0,$i);
    else
      $this->VERSION = $leftover;
    $j = strpos($this->VERSION,".");
    if($j >= 0) { 
      $this->MAJORVER = substr($this->VERSION,0,$j);
      $this->MINORVER = substr($this->VERSION,$j+1,strlen($this->VERSION));
    } else $this->MAJORVER = $this->VERSION;
  }

  function isIEorMozilla() {
    if((($this->BROWSER == "IE") && ((int)$this->VERSION >= 5)) || 
       (($this->BROWSER == "Netscape") && ((int)$this->VERSION >= 5)))    
      return 1;
    else return 0;
  }

  function isLynx() {
    if(strstr($this->UA,"Lynx"))
      return 1;
    else return 0;
  }
}
?>
