<?php
  /**************************************************************************\
  * phpGroupWare application (NNTP)                                               *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

	/* $Id: viewgroup.php,v 1.21 2001/05/17 03:15:15 skeeter Exp $ */
	$phpgw_flags = Array(
		'currentapp'			=> 'nntp',
		'enable_nextmatchs_class'	=> True
	);
	$phpgw_info['flags'] = $phpgw_flags;
	include('../header.inc.php');

	function close_routine()
	{
		global $nntp;
		$nntp->close_port();
	}

	@set_time_limit(0);

	$phpgw->translation->add_app('email');

	$phpgw->db->query("SELECT active FROM newsgroups WHERE con=$folder AND active='Y'");
	if (($phpgw->db->num_rows() == 0) || !$phpgw_info['user']['preferences']['nntp'][$folder] )
	{
		echo 'You do not have access to this newsgroup!'."<br>\n";
		$phpgw->common->phpgw_exit();
	}

	if(!$folder)
	{
		echo lang('Cannot display the requested newsgroup')."<br>\n";
		$phpgw->common->phpgw_exit();
	}

	$nntp->display = $phpgw_info['user']['preferences']['common']['maxmatchs'];
	if ($nntp->errorset)
	{
		echo $nntp->error['msg'].':'.$nntp->error['desc']."<br>\n";
		$phpgw->common->phpgw_exit();
	}
 
	register_shutdown_function("close_routine");

	$p = CreateObject('phpgwapi.Template',$phpgw->common->get_tpl_dir('nntp'));
	$templates = array(
		'view_group' => 'view_group.tpl'
	);
	$p->set_file($templates);
	$p->set_block('view_group','vg','vg');
	$p->set_block('view_group','vg_row','vg_row');

	$nntp->read_table($folder);

	if (!$start) $start = 0;

	if (!$tm) $tm = ($nntp->highmsg - $nntp->lowmsg);
	if (!$fm) $fm = $nntp->lowmsg;

	$var = Array(
		'th_bg'		=> $phpgw_info['theme']['th_bg'],
		'th_font'		=> $phpgw_info['theme']['font'],
		'th_text'		=> $phpgw_info['theme']['th_text'],
		'th_em_folder'	=> $phpgw_info['theme']['em_folder'],
		'th_em_text'	=> $phpgw_info['theme']['em_folder_text'],
		'folder'		=> $nntp->folder,
		'nml'		=> $phpgw->nextmatchs->left('/nntp/viewgroup.php',$start,$tm,'&folder='.$folder.'&tm='.$tm.'&fm='.$fm),
		'nmr'		=> $phpgw->nextmatchs->right('/nntp/viewgroup.php',$start,$tm,'&folder='.$folder.'&tm='.$tm.'&fm='.$fm)
	);

	$p->set_var($var);

	$var = Array(
		'row_color'	=> $phpgw_info['theme']['th_bg'],
		'from'	=> '<font size="2"><b>'.lang('from').'</b></font>',
		'subject'	=> '<font size="2"><b>'.lang('subject').'</b></font>',
		'date'	=> '<font size="2"><b>'.lang('date').'</b></font>'
//		'size'	=> '<font size="2"><b>'.lang('size').'</b></font>'
	);

	$p->set_var($var);
	$p->parse('rows','vg_row',True);

	if ($phpgw_info['user']['preferences']['common']['maxmatchs'] <= ($tm - $start))
	{
		$totaltodisplay = $phpgw_info['user']['preferences']['common']['maxmatchs'];
	}
	else
	{
		$totaltodisplay = ($tm - $start) - 1;
	}

	$firstmessage = ($fm + $start);
	$list = $nntp->get_list('from',$firstmessage,$totaltodisplay);
//	$subject = $nntp->get_list('subject',$firstmessage,$firstmessage+$totaltodisplay);
//	$date = $nntp->get_list('date',$firstmessage,$firstmessage+$totaltodisplay);

	for ($i=0;$i<$totaltodisplay;$i++)
	{
		$tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);

		$subject_url = $phpgw->link('/nntp/read_article.php','folder='.$nntp->con.'&msgnum='.$list[$i]['Msgnum']);

		$var = Array(
			'row_color'	=> $tr_color,
			'from'	=> '<font size="-1">'.$list[$i]['From'].'</font>',
			'subject'	=> '<font size="-1"><a href="'.$subject_url.'">'.$list[$i]['Subject'].'</a></font>',
			'date'	=> '<font size="-2">'.$phpgw->common->show_date($list[$i]['Date']).'</font>'
//			'size'	=> ''
		);
		$p->set_var($var);
//    if ($i < ($start+$totaltodisplay-1))
		$p->parse('rows','vg_row',True);
//      $phpgw->template->parse("output","vg_table_header","True");

  }        
  $p->pparse('out','vg');
  $phpgw->common->phpgw_footer();
?>
