<?php
	/***************************************************************************\
	* phpGroupWare - Notepad													*
	* http://www.phpgroupware.org												*
	* Written by: Andy Holman (LoCdOg)											*
	* -------------------------------------------- 								*
	* This program is free software; you can redistribute it and/or modify it	*
	* under the terms of the GNU General Public License as published by the		*
	* Free Software Foundation; either version 2 of the License, or (at your	*
	* option) any later version.												*
	\***************************************************************************/
	/* $Id: add.php,v 1.33 2001/05/15 14:36:06 milosch Exp $ */

	$phpgw_info['flags'] = array('currentapp' => 'notes',
					'enable_categories_class' => True);
	include('../header.inc.php');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('form' => 'form.tpl'));
	$t->set_block('form','add','addhandle');
	$t->set_block('form','edit','edithandle');

	if (isset($phpgw_info['user']['preferences']['notes']['notes_font']))
	{
		$font = $phpgw_info['user']['preferences']['notes']['notes_font'];
	}
	else
	{
		$font = set_font();
	}

	if (isset($phpgw_info['user']['preferences']['notes']['notes_font_size']))
	{
		$font_size = $phpgw_info['user']['preferences']['notes']['notes_font_size'];
	}
	else
	{
		$font_size = set_font_size();
	}

	$hidden_vars = '<input type="hidden" name="start" value="' . $start . '">' . "\n"
				. '<input type="hidden" name="search" value="' . $search . '">' . "\n"
				. '<input type="hidden" name="cat_id" value="' . $cat_id . '">' . "\n";

	$t->set_var('hidden_vars',$hidden_vars);

	if ($new_cat)
	{
		$cat_id = $new_cat;
	}

### DO NOT TOUCH BELOW THIS LINE ###

	if($addnote)
	{

### SET ACCOUNT ID ###

		$accountid = $phpgw_info['user']['account_id'];

### SET THE QUERY STRING ###

		$note = addslashes($note);

## SET TIME ###

		$time = time();

		if ($access)
		{
			$access = 'private';
		}
		else
		{
			$access = 'public';
		}

		$phpgw->db->query("INSERT INTO phpgw_notes (note_owner,note_access,note_date,note_content,note_category) VALUES ('$accountid','$access','$time','$note','$cat_id')");
		$name = $phpgw_info['user']['fullname'];
		$t->set_var('message',lang('Note has been added for x !',$name));
	}

	if(!$addnote)
	{
		$t->set_var('message','');
	}

	$t->set_var('lang_action',lang('Add a note for'));
	$t->set_var('actionurl',$phpgw->link('/notes/add.php'));
	$t->set_var('font',$font);
	$t->set_var('font_size',$font_size);
	$t->set_var('name',$phpgw_info['user']['fullname']);
	$t->set_var('note',$phpgw->strip_html($note));
	$t->set_var('main_cat_list',$phpgw->categories->formated_list('select','all',$cat_id,'True'));
	$t->set_var('lang_category',lang('Category'));
	$t->set_var('lang_choose',lang('Choose the category'));
	$t->set_var('done_action',$phpgw->link('/notes/index.php',"cat_id=$cat_id&start=$start&search=$search"));
	$t->set_var('lang_access',lang('Private'));

	if ($access)
	{
		$t->set_var('access', '<input type="checkbox" name="access" value="True" checked>');
	}
	else
	{
		$t->set_var('access', '<input type="checkbox" name="access" value="True">');
	}

	$t->set_var('lang_done',lang('Done'));
	$t->set_var('lang_add',lang('Add'));
	$t->set_var('lang_reset',lang('Clear Form'));
	$t->set_var('edithandle','');
	$t->set_var('addhandle','');
	$t->pparse('out','form');
	$t->pparse('addhandle','add');

	$phpgw->common->phpgw_footer();
?>
