<?php
	/***************************************************************************\
	* phpGroupWare - Notepad													*
	* http://www.phpgroupware.org												*
	* Written by: Andy Holman (LoCdOg)											*
	* --------------------------------------------								*
	* This program is free software; you can redistribute it and/or modify it	*
	* under the terms of the GNU General Public License as published by the		*
	* Free Software Foundation; either version 2 of the License, or (at your	*
	* option) any later version.												*
	\***************************************************************************/
	/* $Id: edit.php,v 1.31.2.1 2001/06/19 17:05:56 bettina Exp $ */

	if (! $id)
	{
		Header('Location: ' . $phpgw->link('/notes/index.php',"cat_id=$cat_id&start=$start&search=$search"));
		$phpgw->common->phpgw_exit();
	}

	$phpgw_info['flags'] = array('currentapp' => 'notes',
					'enable_categories_class' => True);
	include('../header.inc.php');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('form' => 'form.tpl'));
	$t->set_block('form','add','addhandle');
	$t->set_block('form','edit','edithandle');

	$notes = CreateObject('notes.notes');

	if (isset($phpgw_info['user']['preferences']['notes']['notes_font']))
	{
		$font = $phpgw_info['user']['preferences']['notes']['notes_font'];
	}
	else
	{
		$font = set_font();
	}

	if (isset($phpgw_info['user']['preferences']['notes']['notes_font_size']))
	{
		$font_size = $phpgw_info['user']['preferences']['notes']['notes_font_size'];
	}
	else
	{
		$font_size = set_font_size();
	}

	$hidden_vars = '<input type="hidden" name="start" value="' . $start . '">' . "\n"
				. '<input type="hidden" name="search" value="' . $search . '">' . "\n"
				. '<input type="hidden" name="id" value="' . $id . '">' . "\n"
				. '<input type="hidden" name="cat_id" value="' . $cat_id . '">' . "\n";

	$t->set_var('hidden_vars',$hidden_vars);

	if ($new_cat)
	{
		$cat_id = $new_cat;
	}

#### DO NOT TOUCH BELOW THIS LINE ######

	if($editnote)
	{
		$date = time();
		$accountid = $phpgw_info['user']['account_id'];

### SET THE QUERY STRING ###

		if ($access)
		{
			$access = 'private';
		}
		else
		{
			$access = 'public';
		}

		$note = addslashes($note);
		$phpgw->db->query("UPDATE phpgw_notes set note_content='$note', note_date='$date', note_category='$cat_id', note_access='$access' WHERE note_id='$id'");
		$name = $phpgw_info['user']['fullname'];
		$t->set_var('message',lang('Note has been updated for x !',$name));
	}

	if (!$editnote)
	{
		$t->set_var('message','');
	}

	$t->set_var('lang_action',lang('Edit note for'));
	$t->set_var('actionurl',$phpgw->link('/notes/edit.php'));
	$t->set_var('name',$phpgw_info['user']['fullname']);
	$t->set_var('font',$font);
	$t->set_var('font_size',$font_size);
	$t->set_var('lang_choose',lang('Choose the category'));
	$t->set_var('lang_category',lang('Category'));

	$phpgw->db->query("SELECT * FROM phpgw_notes WHERE note_id='$id'");
	$phpgw->db->next_record();

	$t->set_var('main_cat_list',$phpgw->categories->formated_list('select','all',$phpgw->db->f('note_category'),'True'));
	$t->set_var('note',$phpgw->strip_html($phpgw->db->f('note_content')));
	$t->set_var('lang_access',lang('Private'));

	if ($phpgw->db->f('note_access')=='private')
	{
		$t->set_var('access', '<input type="checkbox" name="access" value="True" checked>');
	}
	else
	{
		$t->set_var('access', '<input type="checkbox" name="access" value="True">');
	}

	$t->set_var('done_action',$phpgw->link('/notes/index.php',"cat_id=$cat_id&start=$start&search=$search"));
	$t->set_var('lang_done',lang('Done'));
	$t->set_var('lang_edit',lang('Edit'));

	if ($notes->check_perms($grants[$phpgw->db->f('note_owner')],PHPGW_ACL_DELETE) || $phpgw->db->f('note_owner') == $phpgw_info['user']['account_id'])
	{
		$t->set_var('delete','<form method="POST" action="' . $phpgw->link('/notes/delete.php',"id=$id&cat_id=$cat_id&start=$start&search=$search") . '"><input type="submit" value="' . lang('Delete') .'"></form>');
	}
	else
	{
		$t->set_var('delete','&nbsp;');
	}

	$t->set_var('edithandle','');
	$t->set_var('addhandle','');
	$t->pparse('out','form');
	$t->pparse('edithandle','edit');

	$phpgw->common->phpgw_footer();
?>
