Attribute VB_Name = "modListTabs"
Option Explicit

Const WM_USER = &H400
Const LB_SETTABSTOPS = &H192         ' Has changed in Win32.
Const LB_SETHORIZONTALEXTENT As Long = &H194   ' Has changed in Win32.
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Long) As Long
Dim scrollbarwidth  As Long    ' Width of horizontal scrollbar.
Dim numtabs As Long            ' Number of tabs needed.
Dim tabstops() As Long         ' Array of value of tab stop of columnn

Public Sub Fill_List(frm As Form, lb As ListBox, sn() As Server)
    Const NUMCHARS = 3  ' Amount of white space between columns.
    
    ' Temporary variables to preserve form font settings:
    Dim hold_fontname As String, hold_fontsize As Integer
    Dim hold_fontbold As Integer, hold_fontitalic As Integer
    Dim hold_fontstrikethru As Integer, hold_fontunderline  As Integer
    
    Dim whiteSpace As Integer, accumtabstops As Integer, dialogUnits As Integer
    Dim fieldVal As String, listline As String
    Dim avgWidth As Single
    
    Dim i As Integer, j As Integer  ' Used in For Next loops.
    Dim biggest_value() As Single   ' Array of longest string of columns.
    Dim retval As Long              ' Return value of Sendfrmssage function
    
    
    ' Save form's font settings so we can use the form to calculate the
    ' TextWidth / Height of the strings to go into the list box.
    hold_fontname = frm.FontName
    hold_fontsize = frm.FontSize
    hold_fontbold = frm.FontBold
    hold_fontitalic = frm.FontItalic
    hold_fontstrikethru = frm.FontStrikethru
    hold_fontunderline = frm.FontUnderline
    
    ' Set form font settings to be identical to list box.
    frm.FontName = lb.FontName
    frm.FontSize = lb.FontSize
    frm.FontBold = lb.FontBold
    frm.FontItalic = lb.FontItalic
    frm.FontStrikethru = lb.FontStrikethru
    frm.FontUnderline = lb.FontUnderline
    
    ' Get the average character width of the current list box font
    ' (in pixels) using the form's TextWidth width frmthod.
    avgWidth = frm.TextWidth("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
    avgWidth = avgWidth / Screen.TwipsPerPixelX / 52
    
    ' Set the white space you want between columns.
    whiteSpace = avgWidth * NUMCHARS
    
    ReDim biggest_value(0 To 2)
    ReDim tabstops(1 To 3)
    
    lb.Clear
    
    'Set the field Titles
    fieldVal = "Server Name"
    dialogUnits = ((frm.TextWidth(fieldVal) / Screen.TwipsPerPixelX + whiteSpace) \ avgWidth) * 4
    If dialogUnits > biggest_value(0) Then biggest_value(0) = dialogUnits
    listline = fieldVal & vbTab
    
    fieldVal = "Base URL"
    dialogUnits = ((frm.TextWidth(fieldVal) / Screen.TwipsPerPixelX + whiteSpace) \ avgWidth) * 4
    If dialogUnits > biggest_value(1) Then biggest_value(1) = dialogUnits
    listline = listline & fieldVal & vbTab
    
    fieldVal = "AutoLogin"
    dialogUnits = ((frm.TextWidth(fieldVal) / Screen.TwipsPerPixelX + whiteSpace) \ avgWidth) * 4
    If dialogUnits > biggest_value(2) Then biggest_value(2) = dialogUnits
    listline = listline & fieldVal & vbTab
    
    lb.AddItem listline

    ' Loop through the field values for each record in the snapshot.
    ' Calculate the width required for that field value to fit in the list
    ' box. Also, build each line of the list box and add it to the list as
    ' you go.
    For i = 0 To UBound(sn)
        ' The LB_SETTABSTOP frmssage requires coordinates in dialog units
        ' (roughly 4 *, the average character width in pixels).
        
        fieldVal = sn(i).FriendlyName
        If iDefaultServer = i Then
            fieldVal = fieldVal & " (default)"
        End If
        dialogUnits = ((frm.TextWidth(fieldVal) / Screen.TwipsPerPixelX + whiteSpace) \ avgWidth) * 4
        If dialogUnits > biggest_value(0) Then biggest_value(0) = dialogUnits
        listline = fieldVal & vbTab
        
        fieldVal = sn(i).BaseURL
        dialogUnits = ((frm.TextWidth(fieldVal) / Screen.TwipsPerPixelX + whiteSpace) \ avgWidth) * 4
        If dialogUnits > biggest_value(1) Then biggest_value(1) = dialogUnits
        listline = listline & fieldVal & vbTab
        
        fieldVal = IIf(sn(i).AutoLogin, "Yes", "No")
        dialogUnits = ((frm.TextWidth(fieldVal) / Screen.TwipsPerPixelX + whiteSpace) \ avgWidth) * 4
        If dialogUnits > biggest_value(2) Then biggest_value(2) = dialogUnits
        listline = listline & fieldVal & vbTab
        
        lb.AddItem listline
        listline = ""
    Next i
    
    ' Fill the tabstops() array with the position of each tab stop.
    For i = 0 To 2
        accumtabstops = accumtabstops + biggest_value(i)
        tabstops(i + 1) = accumtabstops
    Next i
    
    ' numtabs must be a Long for Win32, Integer for Win16.
    numtabs = i
    ' Send LB_SETTABSTOP to the list box to set the position of each
    ' column.
    
    retval& = SendMessage(lb.hwnd, LB_SETTABSTOPS, numtabs, tabstops(1))
    
    ' Set the horizontal extent just wider than the first tab stop.
    ' This produces a horizontal scroll bar on the list box.
    ' This frmssage requires coordinates in pixels, so we convert the tab
    ' stop coordinate back from dialog units to pixels.
    
    ' scrollbarwidth must be a Long for Win32, Integer for Win16
    scrollbarwidth = (tabstops(i) \ 4) * avgWidth
    retval& = SendMessage(lb.hwnd, LB_SETHORIZONTALEXTENT, scrollbarwidth, 0&)
    
    ' Restore form's original font property settings.
    frm.FontName = hold_fontname
    frm.FontSize = hold_fontsize
    frm.FontBold = hold_fontbold
    frm.FontItalic = hold_fontitalic
    frm.FontStrikethru = hold_fontstrikethru
    frm.FontUnderline = hold_fontunderline
End Sub


