<?php

function print_info_box($progstatus)
{
  global $phpgw;

  $t = $phpgw->template;
  $t->set_file("info", "info.tpl");
  $t->set_var(array("infotitle" => lang("Current Network Status"),
                    "lastupdate" => lang("Last Updated %1", date('r', $progstatus['timestamp'])),
                    "indexlink" => "<A href=\"". $phpgw->link("/phpgwnetsaint/index.php"). "\">" . lang("View Totals Page"). "</A>",
                    "servicelink" => "<A href=\"". $phpgw->link("/phpgwnetsaint/details.php"). "\">" . lang("View Service Details"). "</A>",
             ));
  $t->parse("out", "info", TRUE);
  $t->p("out");
}
function print_host_status($pgns_hostcount)
{
  global $phpgw;
  
  $t = $phpgw->template;
  $t->set_file(array("host_status" => "host_status.tpl"));
  $t->set_var(array("uptitle" => lang("Up"),
                    "downtitle" => lang("Down"),
		    "unreachtitle" => lang("Unreachable"),
		    "pendingtitle" => lang("Pending"),
		    "allprobtitle" => lang("All Problems"),
		    "alltypetitle" => lang("All Types"),
		    ));
  if ($pgns_hostcount['UP'] > 0) {
    $t->set_var("upclass", "hostTotalsUP");
  } else {
    $t->set_var("upclass", "hostTotals");
  }
  if ($pgns_hostcount['DOWN'] > 0) {
    $t->set_var("downclass", "hostTotalsDOWN");
  } else {
    $t->set_var("downclass", "hostTotals");
  }
  if ($pgns_hostcount['UNREACHABLE'] > 0) {
    $t->set_var("unreachclass", "hostTotalsUNREACHABLE");
  } else {
    $t->set_var("unreachclass", "hostTotals");
  }
  if ($pgns_hostcount['PENDING'] > 0) {
    $t->set_var("pendingclass", "hostTotalsPENDING");
  } else {
    $t->set_var("pendingclass", "hostTotals");
  }
  $allprobs = $pgns_hostcount['DOWN'] + $pgns_hostcount['UNREACHABLE'];
  if ($allprobs > 0) {
    $t->set_var("allprobclass", "hostTotalsWarning");
  } else {
    $t->set_var("allprobclass", "hostTotals");
  }
  $t->set_var("upcount", $pgns_hostcount['UP']);
  $t->set_var("downcount", $pgns_hostcount['DOWN']);
  $t->set_var("unreachcount", $pgns_hostcount['UNREACHABLE']);
  $t->set_var("pendingcount", $pgns_hostcount['PENDING']);
  $t->set_var("allprobcount", $allprobs);
  $t->set_var("alltypecount", $pgns_hostcount['UP'] + $pgns_hostcount['PENDING'] + $pgns_hostcount['DOWN'] + $pgns_hostcount['UNREACHABLE']);
  $t->parse("out", "host_status", TRUE);
  $t->p("out");
}

function print_service_status($pgns_servcount)
{
  global $phpgw;
  
  $t = $phpgw->template;
  $t->set_file(array("service_status" => "service_status.tpl"));
  $t->set_var(array("oktitle" => lang("OK"),
                    "warntitle" => lang("Warning"),
		    "unknowntitle" => lang("Unknown"),
		    "crittitle" => lang("Critical"),
		    "pendingtitle" => lang("Pending"),
		    "allprobtitle" => lang("All Problems"),
		    "alltypetitle" => lang("All Types"),
		    ));
  if ($pgns_servcount['OK'] > 0) {
    $t->set_var("okclass", "serviceTotalsOK");
  } else {
    $t->set_var("okclass", "serviceTotals");
  }
  if ($pgns_servcount['WARNING'] > 0) {
    $t->set_var("warnclass", "serviceTotalsWARNING");
  } else {
    $t->set_var("warnclass", "serviceTotals");
  }
  if ($pgns_servcount['UNKNOWN'] > 0) {
    $t->set_var("unknownclass", "serviceTotalsUNKNOWN");
  } else {
    $t->set_var("unknownclass", "serviceTotals");
  }
  if ($pgns_servcount['CRITICAL'] > 0) {
    $t->set_var("critclass", "serviceTotalsCRITICAL");
  } else {
    $t->set_var("critclass", "serviceTotals");
  }
  if ($pgns_servcount['PENDING'] > 0) {
    $t->set_var("pendingclass", "serviceTotalsPENDING");
  } else {
    $t->set_var("pendingclass", "serviceTotals");
  }
  $t->set_var("okcount" , $pgns_servcount['OK']);
  $t->set_var("warncount" , $pgns_servcount['WARNING']);
  $t->set_var("unknowncount" , $pgns_servcount['UNKNOWN']);
  $t->set_var("critcount" , $pgns_servcount['CRITICAL']);
  $t->set_var("pendingcount" , $pgns_servcount['PENDING']);
  $allprob = $pgns_servcount['WARNING'] + $pgns_servcount['CRITICAL'];
  if ($allprob > 0) {
    $t->set_var("allprobclass", "serviceTotalsPROBLEMS");
  } else {
    $t->set_var("allprobclass", "serviceTotals");
  }

  $t->set_var("allprobcount" , $allprob);
  $t->set_var("alltypecount" , ($pgns_servcount['OK'] + $pgns_servcount['WARNING'] + $pgns_servcount['UNKNOWN'] + $pgns_servcount['CRTICAL'] + $pgns_servcount['PENDING']));
  $t->parse("out", "service_status", TRUE);
  $t->p("out");
}

function print_service_details($pgns_servstatus, $hostname= 'all', $hlevel = 'all', $slevel= 'all')
{
  global $phpgw;

  $statetostate = array ('OK' => lang('OK'),
                         'RECOVERY' => lang('Recovery'),
                         'WARNING' => lang('Warning'),
			 'UNKNOWN' => lang('Unknown'),
			 'CRITICAL' => lang('Critical'),
			 'PENDING' => lang('Pending'));

  $t = $phpgw->template;
  $t->set_file(array("details" => "details.tpl"));
  $t->set_block("details", "statusrow", "statusrows");
  if ($hostname == 'all') {
    $t->set_var("detailstitle", lang("Service Details For All Hosts"));
  } else {
    $t->set_var("detailstitle", lang("Service Details For Host '%1'",$hostname));
  }
  $t->set_var("typeinfo", lang("Displaying services with host status %1 and service status level %2", $hlevel, $slevel));

  $t->set_var(array("hosttitle" => lang("Host"),
                    "servicetitle" => lang("Service"),
		    "statustitle" => lang("Status"),
		    "lastctitle" => lang("Last Checked"),
		    "durationtitle" => lang("Duration"),
		    "attempttitle" => lang("Attempt"),
		    "infotitle" => lang("Information")
		    ));
  
  $oldhost = "";
  $odd = FALSE;
  while (list($key,$line) = each($pgns_servstatus))
  {
  if ($hostname != 'all' && $hostname != $line['host']) {
   continue;
  }


  if ($oldhost == $line['host']) {
    $t->set_var("host", " ");
  } else {
    $t->set_var("host", "<A href='". $phpgw->link("/phpgwnetsaint/details.php","targethost=". $line['host'] ) . "'>". $line['host'] . "</a>");
  }
  $t->set_var(array("service" => $line['service'],
                    "status" => $statetostate[$line['state']],
		    "statusclass" => ( "status" . $line['state'] ),
		    "lastc" => strftime('%a %b %d %T %Z %Y', $line['timestamp']),
		    "duration" => my_difftime($line['last_state_change'], time()),
                    "attempt" => $line['current_attempt'] . '/' . $line['max_attempts'],
		    "info" => $line['plugin_output']));
  if ($odd) {
    $odd = FALSE;
    $t->set_var("rowclass", "statusOdd");
  } else {
    $odd = TRUE;
    $t->set_var("rowclass", "statusEven");
  }
  $t->parse("statusrows", "statusrow", TRUE);
  $oldhost = $line['host'];
  }
  $t->parse("out", "details", TRUE);
  $t->p("out");
}

?>
