<?php
   /**
    **  delete_message.php
    **
    **  Copyright (c) 1999-2000 The SquirrelMail development team
    **  Licensed under the GNU GPL. For full terms see the file COPYING.
    **
    **  Deletes a meesage from the IMAP server 
    **
    **  $Id: delete_message.php,v 1.5 2001/02/25 22:23:20 lkneschke Exp $
    **/

   $enablePHPGW = 1;

   if ($enablePHPGW)
   {
   	// store the value of $mailbox, because it will overwriten
   	$MAILBOX = $mailbox;
   	$phpgw_info["flags"] = array("currentapp" => "squirrelmail","noheader" => True, "nonavbar" => True);
   	include("../../header.inc.php");
   	$mailbox = $MAILBOX;

   }
   else
   {
   	session_start();
   }

   if (!isset($strings_php))
      include("../functions/strings.php");
   if (!isset($config_php))
      include("../config/config.php");

	$key      = $phpgw_info["user"]["preferences"]["email"]["passwd"];
	$username = $phpgw_info["user"]["preferences"]["email"]["userid"];

   if (!isset($page_header_php))
      include("../functions/page_header.php");
   if (!isset($display_message_php))
      include("../functions/display_messages.php");
   if (!isset($imap_php))
      include("../functions/imap.php");

   include("../src/load_prefs.php");

   $imapConnection = sqimap_login($username, $key, $imapServerAddress, $imapPort, 0);
   sqimap_mailbox_select($imapConnection, $mailbox);

   sqimap_messages_delete($imapConnection, $message, $message, $mailbox);
   if ($auto_expunge)
      sqimap_mailbox_expunge($imapConnection, $mailbox, true);

	$location = $phpgw_info["server"]["webserver_url"] . "/squirrelmail/src";
	if ($where && $what)
	{
		header ("Location: " . $phpgw->link($location . "/search.php",
			"where=".urlencode($where)."&what=".urlencode($what)."&mailbox=".urlencode($mailbox)));
	}
	else   
	{
		header ("Location: " . $phpgw->link("index.php",
			"sort=$sort&startMessage=$startMessage&mailbox=".urlencode($mailbox)));
	}

   sqimap_logout($imapConnection);
   if ($enablePHPGW)
   {
        $sessionData->save();
        $phpgw->common->phpgw_footer();
   }  
?>
