<?php
	/**************************************************************************\
	* phpGroupWare - todo list                                                 *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: delete.php,v 1.21.2.1 2001/06/23 03:26:13 jengo Exp $ */

	$phpgw_info['flags'] = array(
		'noheader'   => True,
		'nonavbar'   => True,
		'nofooter'   => True,
		'currentapp' => 'todo'
	);

	include('../header.inc.php');

	$_query = urlencode(stripslashes($query));
	if (! $todo_id)
	{
		Header('Location: ' . $phpgw->link('/todo/index.php',"&sort=$sort&order=$order&query=$_query&start=$start"
			. "&filter=$filter&cat_id=$cat_id"));
	}

	$phpgw->todo = createobject('todo.todo');
	if (! $phpgw->todo->check_record_rights($todo_id,PHPGW_ACL_DELETE))
	{
		Header('Location: ' . $phpgw->link('/todo/index.php',"&sort=$sort&order=$order&query=$_query&start=$start"
			. "&filter=$filter&cat_id$cat_id"));
	}

	if ($confirm)
	{
		$phpgw->todo->delete($todo_id);

		Header('Location: ' . $phpgw->link('/todo/index.php',"cd=16&sort=$sort&order=$order&query=$_query&start="
			. "$start&filter=$filter&cat_id=$cat_id"));
	}
	else
	{
		$phpgw->common->phpgw_header();
		echo parse_navbar();

		$common_hidden_vars =
		  "<input type=\"hidden\" name=\"sort\" value=\"$sort\">\n"
		. "<input type=\"hidden\" name=\"order\" value=\"$order\">\n"
		. "<input type=\"hidden\" name=\"query\" value=\"$query\">\n"
		. "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
		. "<input type=\"hidden\" name=\"cat_id\" value=\"$cat_id\">\n"
		. "<input type=\"hidden\" name=\"filter\" value=\"$filter\">\n";

		$phpgw->template = new Template($phpgw->common->get_tpl_dir('todo'));
		$phpgw->template->set_file(array(
			'todo_delete' => 'delete.tpl'
		));

		$phpgw->template->set_var('deleteheader',lang('Are you sure you want to delete this entry'));

		$nolinkf = $phpgw->link('/todo/index.php',"sort=$sort&order=$order&query=$_query&start=$start&filter=$filter&cat_id=$cat_id");
		$nolink = '<a href="' . $nolinkf . '">' . lang('No') .'</a>';
		$phpgw->template->set_var('nolink',$nolink);

		$yeslinkf = $phpgw->link('/todo/delete.php',"todo_id=$todo_id&confirm=True&sort="
			. "$sort&order=$order&query=$_query&start=$start&filter=$filter&cat_id=$cat_id");

		$yeslink = '<a href="' . $yeslinkf . '">' . lang('Yes') . '</a>';

		$phpgw->template->set_var('yeslink',$yeslink);

		$phpgw->template->pfp('out','todo_delete');

		$phpgw->common->phpgw_footer();
		echo parse_navbar_end();
	}
?>