<?php
  /**************************************************************************\
  * phpGroupWare - Weather Center Metar Region Functions                     *
  * http://www.phpgroupware.org                                              *
  * This file written by Sam Wynn <neotexan@wynnsite.com>                    *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: metar_regions.inc.php,v 1.8 2001/03/28 16:07:28 neotexan Exp $ */

function region_table($order, $sort, $filter, $start, $query, &$table_c)
{
    global $phpgw, $phpgw_info;
    
    $edit_label   = lang("Edit");
    $delete_label = lang("Delete");
    
    if ($order)
    {
        $ordermethod = "order by $order $sort ";
    }
    else
    {
        $ordermethod = "order by region_name asc ";
    }
    
    if (! $sort)
    {
        $sort = "desc";
    }
    
    if (! $start)
    {
        $start = 0;
    }
    
    if (! $filter)
    {
        $filter = "none";
    }
    
    $limit = $phpgw->db->limit($start);
    
    if (!$query)
    {
        $phpgw->db->query("select count(*) from phpgw_weather_region "
                          .$ordermethod);
    }
    else
    {
        $phpgw->db->query("select count(*) from phpgw_weather_region "
                          ."WHERE region_name like '%$query%' "
                          .$ordermethod);
    }
    
    $phpgw->db->next_record();

    if ($phpgw->db->f(0) >
        $phpgw_info["user"]["preferences"]["common"]["maxmatchs"])
    {
        $match_comment = 
            lang("showing x - x of x",($start + 1),
                 ($start +
                  $phpgw_info["user"]["preferences"]["common"]["maxmatchs"]),
                 $phpgw->db->f(0));
    }
    else
    {
        $match_comment = lang("showing x",$phpgw->db->f(0));
    }
    
    $match_bar =
        $phpgw->nextmatchs->show_tpl("/weather/admin_regions.php",
                                     $start,$phpgw->db->f(0), "",
                                     "85%", $phpgw_info["theme"]["th_bg"],0,0);
    $region_id_link_label =
        $phpgw->nextmatchs->show_sort_order($sort,"region_id",$order,
                                            "/weather/admin_regions.php",
                                            lang("ID"));
    $region_link_label = 
        $phpgw->nextmatchs->show_sort_order($sort,"region_name",$order,
                                            "/weather/admin_regions.php",
                                            lang("Region"));
    
    if (! $query)
    {
        $phpgw->db->query("select * from phpgw_weather_region "
                          .$ordermethod
                          .$limit);
    }
    else
    {
        $phpgw->db->query("select * from phpgw_weather_region "
                          ."WHERE region_name like '%$query%' "
                          .$ordermethod
                          .$limit);
    }
    
    $table_tpl =
        CreateObject('phpgwapi.Template',
                     $phpgw->common->get_tpl_dir('weather'));
    $table_tpl->set_unknowns("remove");
    $table_tpl->set_file(array(table => "table.regions.tpl",
                               row   => "row.regions.tpl"));
    
    while ($phpgw->db->next_record()) 
    {
        $tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
        
        $region_id = $phpgw->db->f("region_id");
        $region_encoded = urlencode($region_id);
        
        if (! $region_id)
        {
            $region_id = "&nbsp;";
        }
        
        $region = $phpgw->db->f("region_name");
        if (! $region)
        {
            $region = "&nbsp;";
        }
        
        $table_tpl->
            set_var(
                array(row_color    => $tr_color,
                      region_id    => $region_id,
                      region_name  => $region,
                      edit_url     => $phpgw->link("/weather/admin_regions.php",
                                                   "con=".$region_encoded
                                                   ."&act=edit"
                                                   ."&start=$start"
                                                   ."&order=$order"
                                                   ."&filter=$filter"
                                                   ."&sort=$sort"
                                                   ."&query="
                                                   .urlencode($query)),
                      edit_label   => $edit_label,
                      delete_url   => $phpgw->link("/weather/admin_regions.php",
                                                   "con=".$region_encoded
                                                   ."&act=delete"
                                                   ."&start=$start"
                                                   ."&order=$order"
                                                   ."&filter=$filter"
                                                   ."&sort=$sort"
                                                   ."&query="
                                                   .urlencode($query)),
                      delete_label => $delete_label));
        $table_tpl->parse(region_rows, "row", True);
    }
    
    $table_tpl->
        set_var(array
                (th_bg                => $phpgw_info["theme"]["th_bg"],

                 total_matchs         => $match_comment,
                 next_matchs          => $match_bar,
                 
                 region_id_link_label => $region_id_link_label,
                 region_link_label    => $region_link_label,

                 edit_label           => $edit_label,
                 delete_label         => $delete_label,
                 
                 action_url           => $action_url,
                 action_label         => lang($act),
                 reset_label          => lang("Reset")));
    
    $table_tpl->parse(table_part, "table");
    $table_c = $table_tpl->get("table_part");
}


function region_entry($con, $act, $order, $sort, $filter, $start, $query, &$form_c)
{
    global $phpgw, $phpgw_info;

    $action_url   = $phpgw->link("/weather/admin_regions.php",
                                 "act=$act"
                                 ."&start=$start&order=$order&filter=$filter"
                                 ."&sort=$sort"
                                 ."&query=".urlencode($query));
    
    switch($act)
    {
      case "add":
        $bg_color = $phpgw_info["theme"]["th_bg"];
        break;
      case "delete":
        $bg_color = $phpgw_info["theme"]["bg07"];
        break;
      default:
        $bg_color = $phpgw_info["theme"]["table_bg"];
        break;
    }

    $region_name = "";
    
    if ($con != "")
    {
        $phpgw->db->query("select * from phpgw_weather_region where region_id=$con");

        $phpgw->db->next_record();

        $region_name = $phpgw->db->f("region_name");
    }
        
    $modify_tpl =
        CreateObject('phpgwapi.Template',
                     $phpgw->common->get_tpl_dir('weather'));
    $modify_tpl->set_unknowns("remove");
    $modify_tpl->set_file(form, "form.regions.tpl");
    
    $modify_tpl->
        set_var(array
                (bg_color         => $bg_color,
                 
                 region_id        => $con,
                 region_label     => lang("Region"),
                 region_name      => $region_name,
                 
                 action_url       => $action_url,
                 action_label     => lang($act),
                 reset_label      => lang("Reset")));
    
    $modify_tpl->parse(form_part, "form");
    $form_c = $modify_tpl->get("form_part");
}

?>
