#!/bin/sh
#
# $NetBSD: pksd.sh,v 1.1.1.1 2000/07/27 16:10:24 jlam Exp $
#
# PROVIDE: pksd
# REQUIRE: DAEMON

name="pksd"
command=${1:-start}

case ${command} in
start)
	if [ ! -f /usr/local/etc/${name}.conf ]
	then
		exit 0
	else
		dbdir=`awk '/db_dir/ { print $2 }' < /usr/local/etc/${name}.conf`
	fi
	if [ ! -f ${dbdir}/keydb000 -a -x /usr/local/bin/pksclient ]
	then
		/usr/local/bin/pksclient ${dbdir} create
	fi
	if [ -x /usr/local/bin/${name} -a -x /usr/local/bin/pks-queue-run.sh ]
	then
		echo "Starting ${name}."
		/usr/local/bin/${name} /usr/local/etc/${name}.conf &
		sleep 5
		/usr/local/bin/pks-queue-run.sh /usr/local/etc/${name}.conf
	fi
	;;
stop)
	if [ ! -f /usr/local/etc/${name}.conf ]
	then
		exit 0
	else
		socket=`awk '/socket_name/ { print $2 }' < /usr/local/etc/${name}.conf`
	fi
	if [ -x /usr/local/bin/${name}ctl -a -S ${socket} ]
	then
		echo "Stopping ${name}."
		/usr/local/bin/${name}ctl ${socket} shutdown
	else
		echo "couldn't stop ${name}."
	fi
	;;
restart)
	( $0 stop )
	sleep 1
	$0 start
	;;
esac
exit 0
