! Illustration of 1-1 scaling for polar plot
      implicit none
      real*8 PI
      parameter (PI = 3.1415926535897932384)
		
      character*3 text
      real*8 x0(0:360), y0(0:360)
      real*8 x(0:360), y(0:360), dtr, theta, dx, dy, r
      integer i, j, nsp

      dtr = PI/180.0
      do 1 i=0,360
        x0(i) = cos(dtr * dble (i))
        y0(i) = sin(dtr * dble (i))
    1 continue

! Ask user to specify the output device.

      call plinit()

! Set up viewport and window, but do not draw box

      call plenv(dble (-1.3), dble (1.3), dble (-1.3),
     &  dble (1.3), 1, -2)
      do 2 i = 1,10
        do 3 j = 0,360
          x(j) = 0.1*i*x0(j)
          y(j) = 0.1*i*y0(j)
    3   continue

! Draw circles for polar grid

        call plline(361,x,y)
    2 continue

      call plcol(2)
      do 4 i = 0,11
        theta = 30.0*i
        dx = cos(dtr*theta)
        dy = sin(dtr*theta)

! Draw radial spokes for polar grid

        call pljoin(dble (0.0), dble (0.0), dx, dy)
        write (text,'(i3)') nint(theta)

! Write labels for angle

        text = text(nsp(text):)
        if (dx.ge.0) then
          call plptex(dx, dy, dx, dy, dble (-0.15), text)
        else
          call plptex(dx, dy, -dx, -dy, dble (1.15), text)
        end if
    4 continue

! Draw the graph

      do 5 i=0,360
        r = sin(dtr*dble (5*i))
        x(i) = x0(i) * r
        y(i) = y0(i) * r
    5 continue
      call plcol(3)
      call plline(361,x,y)

      call plcol(4)
      call plmtex
     &  ('t', dble (2.0), dble (0.5), dble (0.5), 
     &  '#frPLPLOT Example 3 - r(#gh)=sin 5#gh')

! Close the plot at end

      call plend
      end

      integer function nsp(text)
!     ==================

! Find first non-space character
      implicit none

      character*(*) text
      integer l, len

      l = len(text)
      nsp = 1
    1 if (text(nsp:nsp).eq.' ' .and. nsp.lt.l) then
        nsp = nsp+1
        goto 1
      end if
      end
