! Demonstration of 3-d plotting      
!      
      implicit none
      real*8 PI
      parameter (PI = 3.1415926535897932384)
      integer i, j, k, opt(4), npts
      parameter (npts=41)

      real*8 x(npts), y(npts), z(npts,npts), xx, yy, r

      character*80 title(4)
      real*8 alt(4),az(4)
      data opt /1,   2,   3,   3/
      data alt /60.0,30.0,60.0,60.0/
      data az  /30.0,60.0,120.0,160.0/
      data title /'#frPLPLOT Example 8 - Alt=60, Az=30, Opt=1',
     *            '#frPLPLOT Example 8 - Alt=30, Az=60, Opt=2',
     *            '#frPLPLOT Example 8 - Alt=60, Az=120, Opt=3',
     *            '#frPLPLOT Example 8 - Alt=60, Az=160, Opt=3'/

      do 1 i=1,npts
        x(i) = (i-1-(npts/2))/dble (npts/2)
        y(i) = (i-1-(npts/2))/dble (npts/2)
    1 continue

      do 2 i=1,npts
        xx = x(i)
        do 3 j=1,npts
          yy = y(j)
          r = sqrt(xx*xx + yy*yy)
          z(i,j) = exp(-r*r) * cos(2.0*PI*r)
    3   continue
    2 continue

      call plinit()
      do 5 k=1,4
         call pladv(0)
         call plcol(1)
         call plvpor(dble (0.0), dble (1.0), dble (0.0), dble (0.9) )
         call plwind(dble (-1.0), dble (1.0), dble (-0.9), dble (1.1) )
         call plw3d(dble (1.0), dble (1.0), dble (1.0), dble (-1.0),
     &     dble (1.0), dble (-1.0), dble (1.0), dble (-1.0),
     &     dble (1.0), alt(k),az(k))
         call plbox3('bnstu','x axis', dble (0.0), 
     &     0, 'bnstu', 'y axis', dble (0.0), 0,
     &     'bcdmnstuv','z axis', dble (0.0), 0)
         call plcol(2)
         call plot3d(x,y,z,npts,npts,opt(k),1,npts)
         call plcol(3)
         call plmtex('t', dble (1.0), dble (0.5), dble (0.5), title(k))

    5 continue
      call plend

      end
