! Displays the plotter symbols for PLPOIN
      implicit none
      integer i, j, k
      real*8 x, y

      character*3 text

! Full sized page for display

      call plinit()
      call pladv(0)

      call plcol(2)

! Set up viewport and window

      call plvpor(dble (0.1), dble (1.0), dble (0.1), dble (0.9)) 
      call plwind(dble (0.0), dble (1.0), dble (0.0), dble (1.3)) 

! Draw the grid using plbox

      call plbox('bcgt', dble (0.1), 0, 'bcgt', dble (0.1), 0)
      call plcol(15)

! Write the digits below the frame

      do 5 i=0,9
        write (text,'(i1)') i
        call plmtex('b', dble (1.5), dble (0.1*i+0.05),
     &    dble (0.5), text)
    5 continue

      k=0
      do 1 i=0,12

! Write the digits to the left of the frame

        write (text,'(i3)') 10*i
        call plmtex('lv', dble (1.0), dble (1.0-(2*i+1)/26.0),
     &    dble (1.0), text)
        do 2 j=0,9
          x=0.1*j+0.05
          y=1.25-0.1*i

! Display the symbols

          if (k.lt.128) call plpoin(1,x,y,k)
          k=k+1
    2   continue
    1 continue

      call plmtex('t', dble (1.5), dble (0.5), dble (0.5),
     &  'PLPLOT Example 6 - PLPOIN symbols')
      call plend
      end
