# help.tcl --
#
# This file contains code which handles help windows
#
#
#  TkRat software and its included text is Copyright 1996, 1997, 1998
#  by Martin Forssen.
#
#  Postilion software and its included text and images
#  Copyright (C) 1998, 1999, 2000 Nic Bernstein
#
#  The full text of the legal notices is contained in the files called
#  COPYING and COPYRIGHT.TkRat, included with this distribution.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Order of helptext entries
set helporder { intro
              folders
              folderdef
              dbase
              deleting
              grouping
              notification
              userproc
              bugreport}

# Help --
#
# Creates a new help window and shows the requested help-entry (or an
# introduction if none is specified).
#
# Arguments:
# section  - The section to show (may be empty)

proc Help {{subject intro}} {
    global t b help option defaultFont helporder

    # Initialize help texts (if needed)
    if ![info exists help(intro)] {
	InitMessages $option(language) help
    }

    # Create identifier
    set id helpWin
    upvar #0 $id hd
    set w .$id
    set hd(w) $w

    # Create toplevel
    toplevel $w -class Postilion
    wm title $w $t(help_window)
    wm iconname $w $t(help_window)
    wm group $w .
    wm protocol $w WM_DELETE_WINDOW "DismissHelp $id"
    SetIcon $w helpwin

    # Populate window
    label $w.subjects -text $t(subjects)
    scrollbar $w.subjscroll \
	-relief sunken \
	-command "$w.subjlist yview" \
	-highlightthickness 0
    listbox $w.subjlist \
	-yscroll "$w.subjscroll set" \
	-relief sunken \
	-bd 1 \
	-exportselection false \
	-highlightthickness 0 \
	-selectmode single \
	-font $defaultFont 
    # Scroll mouse support added by Stephen Ryan 14 Oct 1999
    bind $w.subjlist <5> [list $w.subjlist yview scroll 5 units]
    bind $w.subjlist <4> [list $w.subjlist yview scroll -5 units]
    bind $w.subjlist <Shift-5> [list $w.subjlist yview scroll 1 units]
    bind $w.subjlist <Shift-4> [list $w.subjlist yview scroll -1 units]
    bind $w.subjlist <Control-5> [list $w.subjlist yview scroll 1 pages]
    bind $w.subjlist <Control-4> [list $w.subjlist yview scroll -1 pages]
    set hd(list) $w.subjlist
    Size $hd(list) subjlist
    set b($hd(list)) help_subjlist
    button $w.dismiss -text $t(dismiss) -command "DismissHelp $id"
    set b($w.dismiss) dismiss
    scrollbar $w.textscroll \
	-relief sunken \
	-command "$w.texttext yview" \
	-highlightthickness 0
    text $w.texttext \
	-yscroll "$w.textscroll set" \
	-setgrid true \
	-wrap word \
	-relief sunken \
	-bd 1 \
	-highlightthickness 0 \
	-font $defaultFont 
    # Scroll mouse support added by Stephen Ryan 14 Oct 1999
    bind $w.texttext <5> [list $w.texttext yview scroll 5 units]
    bind $w.texttext <4> [list $w.texttext yview scroll -5 units]
    bind $w.texttext <Shift-5> [list $w.texttext yview scroll 1 units]
    bind $w.texttext <Shift-4> [list $w.texttext yview scroll -1 units]
    bind $w.texttext <Control-5> [list $w.texttext yview scroll 1 pages]
    bind $w.texttext <Control-4> [list $w.texttext yview scroll -1 pages]
    set hd(text) $w.texttext
    Size $hd(text) helptext
    set b($hd(text)) help_text

    grid $w.subjects -
    grid $w.subjscroll $w.subjlist -sticky nsew -pady 5
    grid $w.dismiss - -column 2 -row 1 -padx 10
    grid $w.textscroll $w.texttext -sticky nsew
    grid columnconfigure $w 1 -weight 1
    grid rowconfigure $w 1 -weight 1
    grid rowconfigure $w 2 -weight 10

    # Bindings
    bind $w <Key-space> "$hd(text) yview scroll 1 pages"
    bind $w <Key-BackSpace> "$hd(text) yview scroll -1 pages"
    bind $hd(list) <ButtonRelease-1> "SelectHelp $id"

    # Populate list
    foreach topic $helporder {
	$hd(list) insert end $help(title,$topic)
    }

    Place $w help

    ShowHelp $id $subject
}

# SelectHelp --
#
# Figure which subject was selected and show that
#
# Arguments:
# id	- The help-window identifier

proc SelectHelp {id} {
    global helporder
    upvar #0 $id hd

    set topic [lindex $helporder [$hd(list) curselection]]
    ShowHelp $id $topic
}


# ShowHelp --
#
# Populates the help window
#
# Arguments:
# id	- The help-window identifier
# topic	- The topic to show

proc ShowHelp {id topic} {
    global help helporder
    upvar #0 $id hd

    # The subject list
    set i [lsearch -exact $helporder $topic]
    if {$i != [$hd(list) curselection]} {
	$hd(list) selection clear 0 end
	$hd(list) selection set $i
    }

    # The text window
    $hd(text) configure -state normal
    $hd(text) delete 0.0 end
    $hd(text) insert end $help($topic)
    $hd(text) configure -state disabled
}

# DismissHelp --
#
# DImisses the help window
#
# Arguments:
# id	- The help-window identifier

proc DismissHelp {id} {
    upvar #0 $id hd

    RecordSize $hd(list) subjlist
    RecordSize $hd(text) helptext
    RecordPos $hd(w) help
    destroy $hd(w)
    destroy $hd(w)_icon
    unset hd
}
