# newuser.tcl --
#
# This file contains rotines which ask the user to set some preferences
#
#  Postilion software and its included text and images
#  Copyright (C) 1998 Nic Bernstein
#
#  The full text of the legal notices is contained in the file
#  COPYING, included with this distribution.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# NewUser --
#
# Get some preliminary preferences set by the user
#
# Arguments:

proc NewUser {} {
    global option b t

    set handler .new
    # Create window
    toplevel $handler -class Postilion -height 400 -width 600 \
	-relief raised
    wm resizable $handler 0 0
    wm transient $handler .
    wm title $handler $t(new_user)
    upvar #0 $handler fh
    set fh(w) $handler

    label $handler.label -relief flat -bd 0 -text "Postilion" \
	-font {Helvetica 24 bold italic} -fg darkblue
    text $handler.text -relief sunken -bd 2
    frame $handler.buttons

    button $handler.buttons.cancel -text $t(cancel) -state active \
	-relief raised -width 9 -height 2 -anchor center\
	-highlightthickness 0
    button $handler.buttons.prev -text $t(folder_key_prev) -state disabled \
	-relief raised -width 9 -height 2 -anchor center\
	-highlightthickness 0
    button $handler.buttons.next -text $t(folder_key_next) -state disabled \
	-relief raised -width 9 -height 2  -anchor center \
	-highlightthickness 0
    button $handler.buttons.finish -text $t(finish) -state disabled \
	-relief raised -width 9 -height 2 -anchor center \
	-highlightthickness 0

    pack $handler.buttons.cancel $handler.buttons.prev \
	$handler.buttons.next $handler.buttons.finish \
	-padx 5 -side left -expand 0

    place $handler.label -in $handler -x 20 -y 20 \
	-width 120 -height 40
    place $handler.text -in $handler -x 20 -y 70 \
	-width 260 -height 260
    place $handler.buttons -in $handler -x 140 -y 350 \
	-width 380 -height 20

    SetLanguage $handler
}

# SetLanguage --
#
# Let the user select which language to use
#
# Arguments:

proc SetLanguage {handler} {
    global b t option changes welcomeLanguage

    upvar #0 $handler fh

    frame $handler.language -relief raised
    set w $handler.language

    label $w.flag -relief raised -width 80 -height 40 -image en
    label $w.label -textvariable changes(language)
    menubutton $w.menu -textvariable welcomeLanguage \
	-indicatoron 1 -menu $w.menu.m \
	-relief raised -bd 1 -width 20 -anchor c
    menu $w.menu.m -tearoff 0
    pack $w.flag -side top
    pack $w.menu $w.label -side right
    set b($w.menu) welcome_lang

    set i 0
    foreach l [GetLanguages] {
	if ![string length [GetFont [lindex $l 2] 0 {}]] {
	    continue
	}
	$w.menu.m add command -label [lindex $l 1] \
		-command [list SetLang $handler $l]
	if [RatEncodingCompat [lindex $l 2] $option(charset)] {
	    set font [$w.label cget -font]
	} else {
	    set font [GetFont [lindex $l 2] 0 bold]
	}
	$w.menu.m entryconfigure $i -font $font
	incr i
	if ![string compare [lindex $l 0] $option(language)] {
	    SetLang $handler $l
	}
    }

    place $w -in $fh(w) -x 280 -y 70 -width 280 -height 200

    $fh(w).buttons.cancel configure -command "exit 0" -state active
    $fh(w).buttons.prev configure -command "" -state disabled
    $fh(w).buttons.next configure -command "destroy $w" -state active
    $fh(w).buttons.finish configure -command "" -state disabled
    tkwait window $w
    InitMessages $option(language) t
    $fh(w).buttons.cancel configure -text $t(cancel)
    $fh(w).buttons.prev configure -text $t(folder_key_prev)
    $fh(w).buttons.next configure -text $t(folder_key_next)
    $fh(w).buttons.finish configure -text $t(finish)
    SetName $handler
}    

# SetLang --
#
# Effect the language choice
# 
# Arguments:
# handler - the handler for the window
# lang - the language chosen

proc SetLang {handler lang} {
    global option b t defaultFont welcomeLanguage changes
    upvar #0 $handler fh

    set font [GetFont [lindex $lang 2] 0 bold]
    set welcomeLanguage [lindex $lang 1]
    set option(language) [lindex $lang 0]
    set w $fh(w).language
    $w.flag configure -image [lindex $lang 0]
    InitMessages $option(language) changes

    $fh(w).text configure -state normal \
	    -font [GetFont [lindex $lang 2] 0 {}]
    $fh(w).text delete 0.0 end
    $fh(w).text insert 0.0 $changes(welcome)
    $fh(w).text configure -state disabled
    if [RatEncodingCompat [lindex $lang 2] $option(charset)] {
	$w.label configure -font [$w.label cget -font]
	$w.menu configure -font [$w.menu cget -font]
    } else {
	$w.label configure -font $font
	$w.menu configure -font $font
    }
}

# SetName --
#
# Let the user input their name
#
# Arguments:

proc SetName {handler} {
    global b option t env
    upvar #0 $handler fh

    $fh(w).text configure -state normal
    $fh(w).text delete 0.0 end
    $fh(w).text insert 0.0 $t(set_name)
    $fh(w).text configure -state disabled

    frame $handler.name
    set w $handler.name

    frame $w.name
    label $w.name.label -text $t(fullname):
    entry $w.name.entry -relief sunken -textvariable option(fullname) \
	-width 40
    pack $w.name.label $w.name.entry -side left -padx 5

    if ![llength $option(from)] {
	set option(from) $env(USER)@$env(HOST)
    }

    frame $w.from
    label $w.from.label -text $t(use_from_address):
    entry $w.from.entry -textvariable option(from) -width 40
    pack $w.from.label $w.from.entry -side left -padx 5
    pack $w.name $w.from -side top -pady 5
    place $w -in $fh(w) -x 280 -y 70 -width 280 -height 200

    frame $w.reply_to
    label $w.reply_to.label -text $t(default_reply_to_addr):
    entry $w.reply_to.entry -textvariable option(reply_to) -width 40
    pack $w.reply_to.label $w.reply_to.entry -side left -padx 5
    pack $w.name $w.reply_to -side top -pady 5
    place $w -in $fh(w) -x 280 -y 70 -width 280 -height 200

    $fh(w).buttons.cancel configure -command "exit 0" -state active
    $fh(w).buttons.prev configure -state active \
	-command "destroy $w; SetLanguage $handler"
    $fh(w).buttons.next configure -command "" -state disabled
    $fh(w).buttons.finish configure -command "destroy .new" -state active
    tkwait window $w
    return
}    

return
# SetOptionsA --
#
# Ask the user to set certain important options
#
# Arguments:
# handler - the handler for the window

# proc SetOptionsA {handler} {
#     global b option t env
#     upvar #0 $handler fh

#     $fh(w).text configure -state normal
#     $fh(w).text delete 0.0 end
#     $fh(w).text insert 0.0 $t(set_opta)
#     $fh(w).text configure -state disabled

#     frame $handler.opta
#     set w $handler.opta

#     frame $w.
# }
