<?php
// $Id: pnuser.php,v 1.4 2002/02/09 12:56:32 jgm Exp $ $Name:  $
// ----------------------------------------------------------------------
// POST-NUKE Content Management System
// Copyright (C) 2001 by the PostNuke Development Team.
// http://www.postnuke.com/
// ----------------------------------------------------------------------
// Based on:
// PHP-NUKE Web Portal System - http://phpnuke.org/
// Thatware - http://thatware.org/
// ----------------------------------------------------------------------
// LICENSE
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WIthOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Original Author of file: 
// Purpose of file: display x items for a given module
// ----------------------------------------------------------------------
/**
 * main function
 */
function topx_user_main()
{
    $output = new pnHTML();

    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->Text(topx_usermenu());
    $output->SetInputMode(_PNH_PARSEINPUT);

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_READ)) {
        $output->Text(_TOPXNOAUTH);
        return $output->GetOutput();
    }

    // Return output
    return $output->GetOutput();
}
/**
 * contains all functions that are outputted.
 */
function topx_usermenu()
{
    // how many top items are we returning - used for each call to the topx api
    $topx = pnConfigGetVar('top');

    // set this variable empty for E_ALL purposes.  The links generated here do nothing as the modules
    // referenced aren't converted to the new format.
    $item = '';

    $output = new pnHTML();

    $output->TableStart(_TOPXWELCOME .' '. pnConfigGetVar('sitename'));
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->LineBreak(2);
    $output->BoldText(pnConfigGetVar('top') .' '. _TOPXREADSTORIES);
    $output->LineBreak(2);
    $output->SetInputMode(_PNH_PARSEINPUT);
    
    // top x stories ...

    if (!pnModAPILoad('topx', 'user')) {
        $output->Text(_TOPXLOADFAILED);
        return $output->GetOutput();
    }
    $stories = pnModAPIFunc('topx', 'user', 'stories', array('top' => $topx));

    if ($stories == false) {
        $output->Text(_TOPXFAILED);
    }
    $story_count = 1;

    foreach($stories as $story) {
        
        if (pnSecAuthAction(0, 'topx::', "::", ACCESS_READ)) {

            $output->Text($story_count .': ');
	    $output->URL(pnModURL('Temporary',
                                   'user',
                                   'viewdetail',
                                   array('tid' => $item['tid'])),
                          	   pnVarPrepForDisplay(pnVarCensor($story['title'])));
	    $output->Text(' - ('.$story['counter'] .' ' ._TOPXREADS.')');

	    $story_count++;
            $output->Linebreak();
        }
    }
    $output->LineBreak(1);
    $output->BoldText(pnConfigGetVar('top') .' '. _TOPXCOMMENTEDSTORIES);
    $output->LineBreak(2);

    // top x commented stories ..

    if (!pnModAPILoad('topx', 'user')) {
        $output->Text(_TOPXLOADFAILED);
        return $output->GetOutput();
    }
    // Get highest commented stories
    $comms = pnModAPIFunc('topx', 'user', 'comms', array('top' => $topx));

    if ($comms == false) {
        $output->Text(_TOPXFAILED);
    }
    $comment_count = 1;

    foreach($comms as $story_comm) {
        
        if (pnSecAuthAction(0, 'topx::', "::", ACCESS_READ)) {

            $output->Text($comment_count .': ');
	    $output->URL(pnModURL('Temporary',
                                   'user',
                                   'viewdetail',
                                   array('tid' => $item['tid'])),
                          	   pnVarPrepForDisplay(pnVarCensor($story_comm['title'])));
	    $output->Text(' - ('.$story_comm['comments'] .' ' ._TOPXCOMMENTS.')');
	    $comment_count++;
            $output->Linebreak();
        }
    }
    $output->LineBreak(1);
    $output->BoldText(pnConfigGetVar('top') .' '. _TOPXACTIVECAT);
    $output->LineBreak(2);

    // top x active categories ..

    if (!pnModAPILoad('topx', 'user')) {
        $output->Text(_TOPXLOADFAILED);
        return $output->GetOutput();
    }

    // Get most active categories
    $cats = pnModAPIFunc('topx', 'user', 'cats', array('top' => $topx));

    if ($cats == false) {
        $output->Text(_TOPXFAILED);
    }
    $cat_count = 1;

    foreach($cats as $cat) {
        
        if (pnSecAuthAction(0, 'topx::', "::", ACCESS_READ)) {

            $output->Text($cat_count .': ');
	    $output->URL(pnModURL('Temporary',
                                   'user',
                                   'viewdetail',
                                   array('tid' => $item['tid'])),
                          	   pnVarPrepForDisplay(pnVarCensor($cat['title'])));
	    $output->Text(' - ('.$cat['counter'] .' ' ._TOPXHITS.')');
	    $cat_count++;
            $output->Linebreak();
        }
    }
    $output->LineBreak(1);
    $output->BoldText(pnConfigGetVar('top') .' '. _TOPXREADSECTION);
    $output->LineBreak(2);

    // top x active sections ..

    if (!pnModAPILoad('topx', 'user')) {
        $output->Text(_TOPXLOADFAILED);
        return $output->GetOutput();
    }

    // Get highest hit sections
    $sections = pnModAPIFunc('topx', 'user', 'sections', array('top' => $topx));

    if ($sections == false) {
        $output->Text(_TOPXFAILED);
    }
    $sec_count = 1;

    foreach($sections as $section) {
        
        if (pnSecAuthAction(0, 'topx::', "::", ACCESS_READ)) {

            $output->Text($sec_count .': ');
	    $output->URL(pnModURL('Temporary',
                                   'user',
                                   'viewdetail',
                                   array('tid' => $item['tid'])),
                          	   pnVarPrepForDisplay(pnVarCensor($section['title'])));
	    $output->Text(' - ('.$section['counter'] .' ' ._TOPXREADS.')');
	    $sec_count++;
            $output->Linebreak();
        }
    }
    $output->LineBreak(1);
    $output->BoldText(pnConfigGetVar('top') .' '. _TOPXNEWSSUBMITTERS);
    $output->LineBreak(2);

    // top x user submitters ..

    if (!pnModAPILoad('topx', 'user')) {
        $output->Text(_TOPXLOADFAILED);
        return $output->GetOutput();
    }
    // Get top x user submitters
    $user_subs = pnModAPIFunc('topx', 'user', 'users', array('top' => $topx));

    if ($user_subs == false) {
        $output->Text(_TOPXFAILED);
    }
    $user_count = 1;

    foreach($user_subs as $users) {
        
        if (pnSecAuthAction(0, 'topx::', "::", ACCESS_READ)) {

            $output->Text($user_count .': ');
	    $output->URL(pnModURL('Temporary',
                                   'user',
                                   'viewdetail',
                                   array('tid' => $item['tid'])),
                          	   pnVarPrepForDisplay(pnVarCensor($users['uname'])));
	    $output->Text(' - ('.$users['counter'] .' ' ._TOPXNEWSSENT.')');
	    $user_count++;
            $output->Linebreak();
        }
    }
    $output->LineBreak(1);
    $output->BoldText(pnConfigGetVar('top') .' '. _TOPXVOTEDPOLLS);
    $output->LineBreak(2);

    // top x voted on polls ..

    if (!pnModAPILoad('topx', 'user')) {
        $output->Text(_TOPXLOADFAILED);
        return $output->GetOutput();
    }
    // Get highest commented stories
    $polls = pnModAPIFunc('topx', 'user', 'polls', array('top' => $topx));

    if ($polls == false) {
        $output->Text(_TOPXFAILED);
    }
    $poll_count = 1;

    foreach($polls as $poll) {
        
        if (pnSecAuthAction(0, 'topx::', "::", ACCESS_READ)) {

            $output->Text($poll_count .': ');
	    $output->URL(pnModURL('Temporary',
                                   'user',
                                   'viewdetail',
                                   array('tid' => $item['tid'])),
                          	   pnVarPrepForDisplay(pnVarCensor($poll['polltitle'])));
	    $output->Text(' - ('.$poll['voters'] .' ' ._TOPXVOTES.')');
	    $poll_count++;
            $output->Linebreak();
        }
    }
    $output->LineBreak(1);
    $output->BoldText(pnConfigGetVar('top') .' '. _TOPXMOSTACTIVEAUTHORS);
    $output->LineBreak(2);

    // top x authors ..
    if (!pnModAPILoad('topx', 'user')) {
        $output->Text(_TOPXLOADFAILED);
        return $output->GetOutput();
    }
    // Get top x authors
    $authors = pnModAPIFunc('topx', 'user', 'authors', array('top' => $topx));

    if ($authors == false) {
        $output->Text(_TOPXFAILED);
    }
    $author_count = 1;

    foreach($authors as $author) {
        
        if (pnSecAuthAction(0, 'topx::', "::", ACCESS_READ)) {

            $output->Text($author_count .': ');
	    $output->URL(pnModURL('Temporary',
                                   'user',
                                   'viewdetail',
                                   array('tid' => $item['tid'])),
                          	   pnVarPrepForDisplay(pnVarCensor($author['aid'])));
	    $output->Text(' - ('.$author['counter'] .' ' ._TOPXNEWSPUBLISHED.')');
	    $author_count++;
            $output->Linebreak();
        }
    }
    $output->LineBreak(1);
    $output->BoldText(pnConfigGetVar('top') .' '. _TOPXREADREVIEWS);
    $output->LineBreak(2);

    // top x reviews ..

    if (!pnModAPILoad('topx', 'user')) {
        $output->Text(_TOPXLOADFAILED);
        return $output->GetOutput();
    }
    // Get most read reviews
    $reviews = pnModAPIFunc('topx', 'user', 'reviews', array('top' => $topx));

    if ($reviews == false) {
        $output->Text(_TOPXFAILED);
    }
    $review_count = 1;

    foreach($reviews as $review) {
        
        if (pnSecAuthAction(0, 'topx::', "::", ACCESS_READ)) {

            $output->Text($review_count .': ');
	    $output->URL(pnModURL('Temporary',
                                   'user',
                                   'viewdetail',
                                   array('tid' => $item['tid'])),
                          	   pnVarPrepForDisplay(pnVarCensor($review['title'])));
	    $output->Text(' - ('.$review['hits'] .' ' ._TOPXREADS.')');
	    $author_count++;
            $output->Linebreak();
        }
    }
    $output->LineBreak(1);
    $output->BoldText(pnConfigGetVar('top') .' '. _TOPXDOWNLOADEDFILES);
    $output->LineBreak(2);

    // top x downloads

    if (!pnModAPILoad('topx', 'user')) {
        $output->Text(_TOPXLOADFAILED);
        return $output->GetOutput();
    }
    // Get most popular downloads
    $downloads = pnModAPIFunc('topx', 'user', 'downloads', array('top' => $topx));

    if ($downloads == false) {
        $output->Text(_TOPXFAILED);
    }
    $download_count = 1;

    foreach($downloads as $download) {
        
        if (pnSecAuthAction(0, 'topx::', "::", ACCESS_READ)) {

            $output->Text($download_count .': ');
	    $output->URL(pnModURL('Temporary',
                                   'user',
                                   'viewdetail',
                                   array('tid' => $item['tid'])),
                          	   pnVarPrepForDisplay(pnVarCensor($download['title'])));
	    $output->Text(' - ('._TOPXCATEGORY .':'.$download['cattitle'].') - ('. $download['hits'] .' ' ._TOPXDOWNLOADS.')');
	    $download_count++;
            $output->Linebreak();
        }
    }
    // sweet mercy, it's done ..
    $output->TableEnd();

    // Return output
    return $output->GetOutput();
}
?>