<?php
// $Id: pnuserapi.php,v 1.3 2002/02/01 15:04:34 adam_baum Exp $ $Name:  $
// ----------------------------------------------------------------------
// POSTNUKE Content Management System
// Copyright (C) 2001 by the PostNuke Development Team.
// http://www.postnuke.com/
// ----------------------------------------------------------------------
// Based on:
// PHP-NUKE Web Portal System - http://phpnuke.org/
// Thatware - http://thatware.org/
// ----------------------------------------------------------------------
// LICENSE
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WIthOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Original Author of file: 
// Purpose of file: top x user api
// ----------------------------------------------------------------------
/**
 * get top x stories
 * @returns array
 * @return array containing story sid, title, time, counter
 */
function topx_userapi_stories($args)
{
    extract($args);

    if(!isset($top)) {
	pnSessionSetVar('errormsg', _TOPXARGSERROR);
	return false;
    }
    $stories = array();

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_READ)) {
        return $stories;
    }
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $storiestable = $pntable['stories'];
    $storiescolumn = &$pntable['stories_column'];

    // address this for multi-lang shite
    $queryalang = '';

    $sql = buildSimpleQuery('stories', array ('sid',
					      'title', 
					      'time',
					      'counter'), $queryalang, "$storiescolumn[counter] DESC", $top);
    $result = $dbconn->Execute($sql);

    if ($dbconn->ErrorNo() != 0) {
        return false;
    }
    for (; !$result->EOF; $result->MoveNext()) {
        list($sid, $title, $time, $counter) = $result->fields;
	    if($counter > 0) {
                $stories[] = array('sid' => $sid,
				   'title' => $title,
				   'time' => $time,
				   'counter' => $counter);
	    }
    }
    $result->Close();

    return $stories;
}
/**
 * get top x commented stories
 * @returns array
 * @return array containing story sid, title, comments num
 */
function topx_userapi_comms($args)
{
    extract($args);

    if(!isset($top)) {
	pnSessionSetVar('errormsg', _TOPXARGSERROR);
	return false;
    }
    $comms = array();

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_READ)) {
        return $comms;
    }
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $storiestable = $pntable['stories'];
    $storiescolumn = &$pntable['stories_column'];

    // address this for multi-lang shite
    $queryalang = '';

    $sql = buildSimpleQuery('stories', array ('sid',
					      'title',
					      'comments'), $queryalang, "$storiescolumn[comments] DESC", $top);
    $result = $dbconn->Execute($sql);

    if ($dbconn->ErrorNo() != 0) {
        return false;
    }
    for (; !$result->EOF; $result->MoveNext()) {
        list($sid, $title, $comments) = $result->fields;
	    if($comments > 0) {
		$comms[] = array('sid' => $sid,
				 'title' => $title,
				 'comments' => $comments);
	    }
    }
    $result->Close();

    return $comms;
}
/**
 * get top x categories
 * @returns array
 * @return array containing story catid, title, counter
 */
function topx_userapi_cats($args)
{
    extract($args);

    if(!isset($top)) {
	pnSessionSetVar('errormsg', _TOPXARGSERROR);
	return false;
    }
    $cats = array();

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_READ)) {
        return $cats;
    }
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $storiestable = $pntable['stories_cat'];
    $storiescolumn = &$pntable['stories_cat_column'];

    // address this for multi-lang shite
    $queryalang = '';

    $sql = buildSimpleQuery('stories_cat', array ('catid',
						  'title', 
						  'counter'), $queryalang, "$storiescolumn[counter] DESC", $top);
    $result = $dbconn->Execute($sql);

    if ($dbconn->ErrorNo() != 0) {
        return false;
    }
    for (; !$result->EOF; $result->MoveNext()) {
        list($catid, $title, $counter) = $result->fields;
	    if($counter > 0) {
		$cats[] = array('catid' => $catid,
				'title' => $title,
				'counter' => $counter);
	    }
    }
    $result->Close();

    return $cats;
}
/**
 * get top x categories
 * @returns array
 * @return array containing story artid, title, content, counter
 */
function topx_userapi_sections($args)
{
    extract($args);

    if(!isset($top)) {
	pnSessionSetVar('errormsg', _TOPXARGSERROR);
	return false;
    }
    $sections = array();

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_READ)) {
        return $sections;
    }
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $sectionstable = $pntable['seccont'];
    $sectionscolumn = &$pntable['seccont_column'];

    // address this for multi-lang shite
    $queryalang = '';

    $sql = buildSimpleQuery('seccont', array('artid',
					     'secid',
					     'title',
					     'content',
					     'counter'), $queryalang, "$sectionscolumn[counter] DESC", $top);
    $result = $dbconn->Execute($sql);

    if ($dbconn->ErrorNo() != 0) {
        return false;
    }
    for (; !$result->EOF; $result->MoveNext()) {
        list($artid,
	     $secid,
	     $title,
	     $content,
	     $counter) = $result->fields;

	    $sections[] = array('artid' => $artid,
				'secid' => $secid,
				'title' => $title,
				'content' => $content,
				'counter' => $counter);
    }
    $result->Close();

    return $sections;
}
/**
 * get top x users
 * @returns array
 * @return array containing uname, counter
 */
function topx_userapi_users($args)
{
    extract($args);

    if(!isset($top)) {
	pnSessionSetVar('errormsg', _TOPXARGSERROR);
	return false;
    }
    $users = array();

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_READ)) {
        return $users;
    }
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $userstable = $pntable['users'];
    $userscolumn = &$pntable['users_column'];

    // address this for multi-lang shite
    $queryalang = '';

    $sql = buildSimpleQuery('users', array('uname',
					   'counter'), "$userscolumn[counter]>0", "$userscolumn[counter] DESC", $top);
    $result = $dbconn->Execute($sql);

    if ($dbconn->ErrorNo() != 0) {
        return false;
    }
    for (; !$result->EOF; $result->MoveNext()) {
        list($uname,
	     $counter) = $result->fields;

	    $users[] = array('uname' => $uname,
			     'counter' => $counter);
    }
    $result->Close();

    return $users;
}
/**
 * get top x polls
 * @returns array
 * @return array containing pollid, polltitle, and number of voters
 */
function topx_userapi_polls($args)
{
    extract($args);

    if(!isset($top)) {
	pnSessionSetVar('errormsg', _TOPXARGSERROR);
	return false;
    }
    $polls = array();

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_READ)) {
        return $polls;
    }
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $pollstable = $pntable['poll_desc'];
    $pollscolumn = &$pntable['poll_desc_column'];

    $ptable = $pntable['poll_data'];
    $pcolumn = &$pntable['poll_data_column'];

    // address this for multi-lang shite
    $queryalang = '';

    $sql = buildSimpleQuery('poll_desc', array('pollid',
					       'polltitle',
					       'voters'), $queryalang, "$pollscolumn[voters] DESC", $top);
    $result = $dbconn->Execute($sql);

    if ($dbconn->ErrorNo() != 0) {
        return false;
    }
    for (; !$result->EOF; $result->MoveNext()) {
        list($pollID,
	     $pollTitle,
	     $voters) = $result->fields;

        $result2 = $dbconn->Execute("SELECT SUM($pcolumn[optioncount]) AS sum 
					 FROM $ptable WHERE $pcolumn[pollid] = $pollID");
            list($sum) = $result2->fields;
		if((int) $sum > 0) {
		    $polls[] = array('pollid' => $pollID,
				     'polltitle' => $pollTitle,
				     'voters' => $voters,
				     'sum' => $sum);
	        }
    }
    $result->Close();

    return $polls;
}
/**
 * get top x authors
 * @returns array
 * @return array containing aid (author), number of news items
 */
function topx_userapi_authors($args)
{
    extract($args);

    if(!isset($top)) {
	pnSessionSetVar('errormsg', _TOPXARGSERROR);
	return false;
    }
    $authors = array();

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_READ)) {
        return $authors;
    }
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $storiestable = $pntable['stories'];
    $storiescolumn = &$pntable['stories_column'];

    $userstable = $pntable['users'];
    $userscolumn = &$pntable['users_column'];

    $sql = "SELECT $userscolumn[uname], count(*) AS num
                                FROM $storiestable, $userstable
                                WHERE  $storiescolumn[aid] = $userscolumn[uid]
                                GROUP BY $userscolumn[uname]
                                ORDER BY num DESC";

    $result = $dbconn->SelectLimit($sql, $top);

    if ($dbconn->ErrorNo() != 0) {
        return false;
    }
    for (; !$result->EOF; $result->MoveNext()) {
        list($aid, 
	     $counter) = $result->fields;

	    $authors[] = array('aid' => $aid,
			       'counter' => $counter);
    }
    $result->Close();

    return $authors;
}
/**
 * get top x categories
 * @returns array
 * @return array containing id, title, hits
 */
function topx_userapi_reviews($args)
{
    extract($args);

    if(!isset($top)) {
	pnSessionSetVar('errormsg', _TOPXARGSERROR);
	return false;
    }
    $reviews = array();

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_READ)) {
        return $reviews;
    }
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $reviewstable = $pntable['reviews'];
    $reviewscolumn = &$pntable['reviews_column'];

    // address this for multi-lang shite
    $queryalang = '';

    $sql = buildSimpleQuery('reviews', array('id',
					     'title',
					     'hits'), $queryalang, "$reviewscolumn[hits] DESC", $top);
    $result = $dbconn->Execute($sql);

    if ($dbconn->ErrorNo() != 0) {
        return false;
    }
    for (; !$result->EOF; $result->MoveNext()) {
        list($id,
	     $title,
	     $hits) = $result->fields;

	    $reviews[] = array('id' => $id,
			       'title' => $title,
			       'hits' => $hits);
    }
    $result->Close();

    return $reviews;
}
/**
 * get top x downloads
 * @returns array
 * @return array containing lid, cid, title, hits, cattitle
 */
function topx_userapi_downloads($args)
{
    extract($args);

    if(!isset($top)) {
	pnSessionSetVar('errormsg', _TOPXARGSERROR);
	return false;
    }
    $downloads = array();

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_READ)) {
        return $downloads;
    }
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $downloadstable = $pntable['downloads_downloads'];
    $downloadscolumn = &$pntable['downloads_downloads_column'];

    $downloads_cattable = $pntable['downloads_categories'];
    $downloads_catcolumn = &$pntable['downloads_categories_column'];

    // address this for multi-lang shite
    $queryalang = '';

    $sql = buildSimpleQuery('downloads_downloads', array('lid',
							 'cid',
							 'title',
							 'hits'), '', "$downloadscolumn[hits] DESC", $top);
    $result = $dbconn->Execute($sql);

    if ($dbconn->ErrorNo() != 0) {
        return false;
    }
    for (; !$result->EOF; $result->MoveNext()) {
        list($lid,
	     $cid,
	     $title,
	     $hits) = $result->fields;
	
	    $result2 = $dbconn->Execute("SELECT $downloads_catcolumn[title] as cattitle
					 FROM $downloads_cattable WHERE $downloads_catcolumn[cid] = $cid");
            list($cattitle) = $result2->fields;

		$downloads[] = array('lid' => $lid,
				     'cid' => $cid,
				     'title' => $title,
				     'hits' => $hits,
				     'cattitle' => $cattitle);
    }
    $result->Close();

    return $downloads;
}
?>