/* 
 * PVM++ - A C++ library for easy use of PVM
 * Copyright (C) 1997-2001 Sebastian Wilhelmi; University of Karlsruhe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __PVM_EMPTYSTRUCT_HH__
#define __PVM_EMPTYSTRUCT_HH__

#include <pvm++/struct.hh>

namespace Pvm
{
  /** An empty derivation of \Ref{Struct}.
      
      Sometimes you only want to transmit a message without data, e.g. a
      command to end the receiver. Then it would be to much overhead
      (both for programming and for compiling) to define a new class for
      all those messages. As a solution this class is defined. You
      simply have to make instances of this class, constructed with the
      corresponding \Ref{StructId} (It still has to be unique, see
      \Ref{vmStruct}). As an example see the following:
      
      \begin{verbatim}
      Pvm::EmptyStruct Begin (BeginId);
      Pvm::EmptyStruct End (EndId);
      
      Pvm::Task Task;
      Begin.Receive (Task);
      End.Send (Task);
      \end{verbatim} 
  */
  class EmptyStruct : public Struct
  {
  public:
    /** constructs an instance of EmptyStruct with Id as the
	\Ref{StructId}. */
    EmptyStruct (StructId Id);
    
    virtual StructId GetStructId () const;
    virtual Struct *GetNewInstance () const;
  protected:
    virtual void PackOrUnPack ();
  private:
    StructId MyId;
  };

} // namespace Pvm

#endif /* __PVM_EMPTYSTRUCT_HH__ */
