/* 
 * PVM++ - A C++ library for easy use of PVM
 * Copyright (C) 1997-2001 Sebastian Wilhelmi; University of Karlsruhe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __PVM_RECEIVEACTION_HH__
#define __PVM_RECEIVEACTION_HH__

#include <pvm++/types.hh>

namespace Pvm
{

  /** Class representing a certain action on receive.  This class is
      simply a wrapper for the different receive policies, i.e.  normal
      receive (you have to do a Receive*() to get a message),
      message handler (the handler is automatically called on receive of
      a message), automatic unpack (the received message is
      automatically unpacked into a fixed instance of the corresponding
      class) and swallow on receive (a received message is simply
      removed from the input queue). 
      
      @see Struct for Usage. 
  */
 
  class ReceiveAction
  {
  public:
    ReceiveAction (const ReceiveAction &What);
    ReceiveAction ();
  private:
    friend class Struct;
    friend class HandlerTableType;
    
    typedef enum { Normal, Swallow, AutoUnpack, UseHandler } Actions;
    Actions Action;
    
    HandlerFunc Func;
    
    ReceiveAction (Actions What);
    ReceiveAction (HandlerFunc What);
  };

} // namespace Pvm

#endif /* __PVM_RECEIVEACTION_HH__ */
