AC_DEFUN(AC_FIND_FILE,
[
  # parameter:
  #   1: variable to set with directory where file (parameter 3) was found
  #   2/3: directories/file to search for.
  #   4: directories to search in ( for 2/3 ).
  #   5: what to do on success.
  #   6: what to do in the other case.

  for dir1 in $4; do
    for dir2 in $2 .; do
      if test -r "$dir1/$dir2/$3"; then
        break 2
      fi
    done
  done

  if test -r "$dir1/$dir2/$3"; then
    $1=`echo "$dir1/$dir2" | sed -e 's%/./%/%g' -e 's%/.$%%'`
    $5
  else
    unset $1
    $6
  fi

])  

AC_DEFUN(AC_FIND_PVM,
[ 

  dnl ******************************************
  dnl        Dirs, where PVM might be.
  dnl ******************************************

  POSSIBLE_PVM_DIRS="$PVM_ROOT		\
		     /usr		\
		     /usr/local		\
		     /usr/gnu		\
		     /opt/gnu		\
		     /opt/local/pvm3	\
		     /usr/lib/pvm3	\
		     /usr/local/lib/pvm3\
		     /opt/local/pvm	\
		     /usr/lib/pvm	\
		     /usr/local/lib/pvm \
		     $prefix		\
                    "
  dnl ******************************************
  dnl        Checks for pvm headers
  dnl ******************************************
  
  AC_MSG_CHECKING(for pvm headers path)

  AC_ARG_WITH( 
    pvm-incs,	
    [  --with-pvm-incs=DIR     PVM headers are in DIR ],
    [ PVM_INCLUDEDIR="$withval" ],
    [ AC_FIND_FILE( 
      PVM_INCLUDEDIR, 
      include, pvm3.h, 
      $POSSIBLE_PVM_DIRS, 
      [  ],
      [ AC_MSG_RESULT(not found)
        AC_MSG_ERROR( 
         [PVM3 header file pvm3.h not found. Use --with-pvm-incs=DIR] 
      )]
    )]
  )

  PVM_CFLAGS=-I$PVM_INCLUDEDIR
  AC_SUBST(PVM_CFLAGS)
        
  AC_MSG_RESULT($PVM_INCLUDEDIR)

  dnl ******************************************
  dnl       Checks for pvm architecture
  dnl ******************************************

  AC_MSG_CHECKING(for pvm architecture)

  AC_ARG_WITH( 
    pvm-arch,	
    [  --with-pvm-arch=DIR     PVM architecture is ARCH],
    [ PVM_ARCH="$withval" ],
    [ AC_FIND_FILE( 
      PVM_ARCH_PROG, 
      lib, pvmgetarch, 
      $POSSIBLE_PVM_DIRS, 
      [ PVM_ARCH=`$PVM_ARCH_PROG/pvmgetarch` ],
      [ AC_MSG_RESULT(not found)
        AC_MSG_ERROR( 
        [PVM architecture not found. Use --with-pvm-arch=ARCH]
      )]
    )]
  )

  AC_SUBST(PVM_ARCH)

  AC_MSG_RESULT($PVM_ARCH)

  dnl ******************************************
  dnl       Checks for pvm libraries.
  dnl ******************************************

  AC_MSG_CHECKING(for pvm library path)

  AC_ARG_WITH( 
    pvm-libs,	
    [  --with-pvm-libs=DIR     PVM library is in DIR ],
    [ PVM_LIBDIR="$withval" ],
    [ AC_FIND_FILE( 
      PVM_LIBDIR, 
      lib/$PVM_ARCH lib, libpvm3.a, 
      $POSSIBLE_PVM_DIRS, 
      [  ],
      [ AC_MSG_RESULT(not found)
        AC_MSG_ERROR( 
         [PVM3 library libpvm3.a not found. Use --with-pvm-libs=DIR] 
      )]
    )]
  )

  PVM_LDFLAGS="-L$PVM_LIBDIR -lpvm3"

  AC_MSG_RESULT($PVM_LIBDIR)

  dnl ******************************************
  dnl       Checks for aux-libraries for pvm.
  dnl ******************************************

  AC_MSG_CHECKING(for auxiliary pvm libs)

  AC_ARG_WITH( 
    pvm-auxlibs,	
    [  --with-pvm-auxlibs=LDFLAGS     PVM auxiliary libraries are LDFLAGS],
    [ PVM_AUX_LIB="$withval" ],
    [ AC_FIND_FILE( 
      PVM_DEFFILE, 
      conf, $PVM_ARCH.def, 
      $POSSIBLE_PVM_DIRS, 
      [ PVM_AUX_LIB=`grep ARCHLIB $PVM_DEFFILE/$PVM_ARCH.def \
		| grep -v '^#' | head -1 \
		| sed -e 's/.*=//'` ],
      [ AC_MSG_RESULT(not found)
        AC_MSG_ERROR( 
         [PVM3 auxiiliary LDFLAGS not found. Use --with-pvm-auxlibs=LDFLAGS] 
      )]
    )]
  )

  PVM_LDFLAGS="$PVM_LDFLAGS $PVM_AUX_LIB"
  AC_SUBST(PVM_LDFLAGS)

  AC_MSG_RESULT($PVM_AUX_LIB)

])

AC_DEFUN(AC_FIND_PVM_P_P,
[ 

  dnl ******************************************
  dnl        Checks for pvm stuff
  dnl ******************************************
  
  AC_FIND_PVM

  dnl ******************************************
  dnl        Checks for pvm++ headers
  dnl ******************************************
  
  AC_MSG_CHECKING(for pvm++ headers path)

  AC_ARG_WITH( 
    pvmpp-incs,	
    [  --with-pvmpp-incs=DIR   PVM++ headers are in DIR ],
    [ PVM_P_P_INCLUDEDIR="$withval" ],
    [ AC_FIND_FILE( 
      PVM_P_P_INCLUDEDIR, 
      include, pvm++/pvm++.hh, 
      $POSSIBLE_PVM_DIRS, 
      [  ],
      [ AC_MSG_RESULT(not found)
        AC_MSG_ERROR( 
         [PVM++ header file pvm++/pvm++.hh not found. Use --with-pvmpp-incs=DIR] 
      )]
    )]
  )

  PVM_P_P_CFLAGS="-I$PVM_P_P_INCLUDEDIR $PVM_CFLAGS"
  AC_SUBST(PVM_P_P_CFLAGS)
        
  AC_MSG_RESULT($PVM_P_P_INCLUDEDIR)

  dnl ******************************************
  dnl       Checks for pvm++ libraries.
  dnl ******************************************

  AC_MSG_CHECKING(for pvm++ library path)

  AC_ARG_WITH( 
    pvmpp-libs,	
    [  --with-pvmpp-libs=DIR   PVM++ library is in DIR ],
    [ PVM_P_P_LIBDIR="$withval" ],
    [ AC_FIND_FILE( 
      PVM_P_P_LIBDIR, 
      lib/$PVM_ARCH lib, libpvm++.la, 
      $POSSIBLE_PVM_DIRS, 
      [  ],
      [ AC_MSG_RESULT(not found)
        AC_MSG_ERROR( 
         [PVM++ library libpvm++.la not found. Use --with-pvmpp-libs=DIR] 
      )]
    )]
  )

  PVM_P_P_LDFLAGS="-L$PVM_P_P_LIBDIR -lpvm++ $PVM_LDFLAGS"
  AC_SUBST(PVM_P_P_LDFLAGS)

  AC_MSG_RESULT($PVM_P_P_LIBDIR)
  
])
