# PyUI
# Copyright (C) 2001-2002 Sean C. Riley
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of version 2.1 of the GNU Lesser General Public
# License as published by the Free Software Foundation.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
import time
import pyui.locals
import theme2k, theme
import colors
import string
import os

from desktop import Desktop, readTimer
from rendererBase import RendererBase
from renderer3d import Renderer3DBase

###########################################################
# Section: Globals
##########################################################

gRenderer = None
gDesktop = None
gVersion = 0.93

#########################################################
# Section: external/public functions
#
# External/Public Module level functions
#########################################################

def init(w, h, renderer = "gl", fullscreen = 0):
    """Initialize pyui. Will set to fullscreen if specified. default is to run in a window.
    This will return a Desktop Object.
    (public)
    """

    global gDesktop, gRenderer
    
    if renderer == "null":
        gRenderer = RendererBase(w, h, fullscreen)

    elif renderer == "null3d":
        gRenderer = Renderer3DBase(w, h, fullscreen)
        
    elif renderer == "2d":
        import renderer2D
        gRenderer = renderer2D.renderer2D(w, h, fullscreen)
        
    elif renderer == "gl":
        import rendererGLUT
        gRenderer = rendererGLUT.rendererGLUT(w, h, fullscreen)

    elif renderer == "p3d":
        import rendererP3D
        gRenderer = rendererP3D.rendererP3D(w, h, fullscreen)
        
    elif renderer == "dx":
        import rendererDX
        gRenderer = rendererDX.rendererDX(w, h, fullscreen)

    elif renderer == "tk":
        import rendererTK
        gRenderer = rendererTK.rendererTk(w, h, fullscreen)

    elif renderer == "qg":
        import rendererQG
        gRenderer = rendererQG.rendererQG(w, h, fullscreen)

##    THIS is deprecated for now... dont use it. Version 0.93
##    elif renderer == "win32":
##        import rendererWin32
##        gRenderer = rendererWin32.rendererWin32(w, h, fullscreen)
        
    else:
        raise "Unsupported renderer type", renderer
        
    (w , h) = gRenderer.getScreenSize()
    # create the theme and desktop
    #theTheme = theme.dataTheme(gRenderer, w, h)
    theTheme = theme2k.theme2k(gRenderer, w, h)
    gDesktop = Desktop(gRenderer, w, h, fullscreen, theTheme)
    
    colors.init(gRenderer)
    pyui.tree.init()

    return gDesktop
    
def quit():
    """Sets the running flag so that the application knows to quit.
    (public)
    """
    global gDesktop
    gDesktop.quit()
    
def update():
    """Process events from the renderer, and events posted by users or widgets.
    Will return 1 if execution should continue, 0 if we should exit.
    (public)
    """
    global gDesktop
    return gDesktop.update()
    
def draw():    
    """
    fills the background and draws the widgets.
    (public)
    """
    global gDesktop
    gDesktop.draw()

def version():
    """return the version number of pyui"""
    global gVersion
    return gVersion


def run(callback=None):
    global gRenderer
    gRenderer.run(callback)
    

def loadPyuiImage(filename):
    """This loads an image file from the images directory in the pyui install.
    The directory pyui/images holds general images used in pyui that are not
    application specific.
    """
    path = pyui.__path__[0]
    pathElements = list(os.path.split(path)) # string.split(path, "\\")
    pathElements.pop( len(pathElements) -1)
    realName = string.join( pathElements, "/") + "/images/" + filename
    gRenderer.loadImage(realName, filename)

