###
# Application: pyFind
# File:        LoadGlade.py
# Description: Superclass for glade based applications
# Copyright (c) 2001-2002   Andy Balcombe <kinematics _at_ ntlworld.com>
###
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#from gtk import * 
#from gnome.ui import *
import gtk
import gnome.ui
import gnome.util
import libglade

import os.path

class LoadGlade:
    """
    Superclass for glade based applications
    """
    def __init__( self, sFilename, sWindowName, sMode="production" ):
        #set some properties
        self.sFilename = sFilename
        self.sWindowName = sWindowName
        self.sMode = sMode
        #print "LoadGlade: self.sMode=",self.sMode

        #set glade file name
        if self.sMode == "development":
            #development version
            self.sGladeFile = os.path.join('glade', self.sFilename)
        else:
            #production version
            self.sGladeFile = gnome.util.datadir_file( os.path.join('pyFind/glade', self.sFilename)) 

        #load glade file
        self.xml = libglade.GladeXML(self.sGladeFile, self.sWindowName)

        #create signal dictionary
        dict = {}
        for key in dir(self.__class__):
            dict[key] = getattr(self, key)
        self.xml.signal_autoconnect (dict)


    def __getattr__( self, key ):
        #print "LoadGlade.__getattr__(", key, ")"
        w = self.xml.get_widget(key)
        if w is None:
            raise AttributeError("Widget " + key + " not found")
        self.__dict__[key] = w
        return w

    #set this
    __getitem__ = __getattr__
