###
# Application: pyFind
# File:        dlgSaveAs.py
# Description: Preferences dialog
# Copyright (c) 2001-2002   Andy Balcombe <kinematics _at_ ntlworld.com>
###
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#project imports
from LoadGlade import *
import config

class dlgSaveAs(LoadGlade):
    """
    pyfind save as dialog class
    """
    def init_dlgSaveAs(self, app):
        #init prefs
        self.app = app
        self.dlgSaveAs.set_parent(self.app.appMain)
        self.dlgSaveAs.set_transient_for(self.app.appMain)

        #get config
        self.bLoading = 1

        #display save as dialog
        self.bLoading = 0
        self.dlgSaveAs.show()
        
    def on_cmdOK_clicked(self, *args):
        #save list of results
        #print "cmdOK clicked: ", self.dlgSaveAs.get_filename()
        #open file
        f = open( self.dlgSaveAs.get_filename(), "w" )
        #for each row
        for iRow in range(0,self.app.clstFiles.__getattr__("rows")):
            sFilename = self.app.clstFiles.get_text(iRow,2) + "/" + \
                        self.app.clstFiles.get_text(iRow,1)  + "\n"
            f.write(sFilename)
        #done
        f.close()
        self.dlgSaveAs.destroy()

    def on_cmdCancel_clicked(self, *args):
        print "cmdCancel clicked"
        self.dlgSaveAs.destroy()

        