###
# Application: pyFind
# File:        file_srch_rep.py
# Description: Search and replace text within a given filename.
#              Modified by Andy Balcombe from original script 
#              by Jeff Bauer <jbauer@rubic.com>
#              from http://www.activestate.com/ASPN/Python/Cookbook
###
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import os
import shutil
import tempfile
import re
import string  # python 1.5.2

def search_and_replace( sSearchText, sReplaceText, sFilenameIn, sFilenameOut = None, bUseRE = 0, bIgnoreCase = 0 ):
    """
    Search and replace text in a given filename.
        Parameters:
            sSearchText  : string  : Text / regular expression to search for
            sReplaceText : string  : Replace search text with this
            sFilenameIn  : string  : Input filename
            sFilenameOut : string  : Output filename (if blank the input file will be overwritten)
            bUseRE       : boolean : True if sSearchText is a regular expression
            bIgnoreCase  : boolean : True to ignore case (regular expression searches only)
    Returns:
        boolean : True if found a match, False otherwise
    """
    #if no output filename specified, then overwrite input file using
    #a temporary filename in the process
    if sFilenameOut == None or sFilenameIn == sFilenameOut:
        bTemp = 1
        sFilenameOut = tempfile.mktemp()
        # print "temp file = ", sFilenameOut
    else:
        bTemp = 0
        
    #open files
    input = open(sFilenameIn)
    output = open(sFilenameOut, "w")

    #compile reg exp if needed
    if bUseRE:
        reExp = re.compile(sSearchText, reFlags)

    #search and replace
    for s in input.readlines():
        if bUseRE:
            #regular expression
            if bIgnoreCase:
                reFlags = re.IGNORECASE
            else:
                reFlags = 0
            #reExp = re.compile(sSearchText, reFlags)
            output.write( re.sub(reExp, sReplaceText, s) )
        else:
            #normal search / replace
            # output.write(s.replace(sSearchText, sReplaceText)) #python 2.0
            output.write(string.replace(s, sSearchText, sReplaceText))  # python 1.5.2 

    #close files
    input.close()
    output.close()

    #replace input file with temp output file if required
    if bTemp:
        shutil.copyfile( sFilenameOut, sFilenameIn )
        os.remove( sFilenameOut )
