## $Id: builtineditor.py,v 1.1 2001/06/11 12:52:30 kjetilja Exp $

## System modules
from gtk import *

## Local modules
import editor

class BuiltinEditor( editor.Editor ):
    def widget( self ):
	return self.swin

    # create the widget
    def __init__( self, prefs, font='' ):
	self.text = GtkText()
	self.text.set_editable(1)
	self.text.set_word_wrap(1)
	self.text.show()

	if( font != '' ):
	    style = self.text.get_style().copy()
	    style.font = font
	    self.text.set_style(style)

	# Scrollbars
        self.swin = GtkScrolledWindow()
        self.swin.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        self.swin.add(self.text)
        self.swin.show()

    # release all resources
    def destroy( self ):
        self.text.destroy()
        self.swin.destroy()

    # jump to top or bottom of text 
    # pos='top' or pos='bottom'
    def set_scroll_position( self, pos ):
	adj = self.text.get_vadjustment()
	if pos == 'top':
            adj.set_value(0)
	elif pos == 'bottom':
	    adj.set_value( adj.upper )

    def grab_focus( self ):
	self.text.grab_focus()

    def freeze( self ):
	self.text.freeze()

    def thaw( self ):
	self.text.thaw()

    def redraw( self ):
	self.text.queue_draw()

    # insert text at the current cursor position
    def insert_text(  self, text, pos='cursor' ):
	#print "text to insert:", text

	# jump to where we want to insert the text
	if( pos == 'top' ):
	    self.text.set_position( 0 )
	if( pos == 'bottom' ):
	    #print 'insert1'
	    self.text.set_position( self.text.get_length() )
	    #print 'insert2'

	# We cannot insert text in the middle of the widget,
	# so we have to remove all characters after the current
	# position, insert the text, and then insert the saved
	# characters.
	t = self.text
	t.freeze()
	save = t.get_chars(t.get_position(), t.get_length())
	t.delete_text(t.get_position(), t.get_length())
	try:
	    t.insert(None, None, None, text)
	except TypeError:
	    # this occurs if the caller tries to insert a zero-byte file.
	    pass

	t.insert(None, None, None, save)
	t.thaw()
	del save
	

    def sel_all( self ):
        self.text.select_region(0, self.text.get_length())

    def cut_clipboard( self ):
        self.text.cut_clipboard()

    def copy_clipboard( self ):
        self.text.copy_clipboard()

    def paste_clipboard( self ):
        self.text.paste_clipboard()

    def insert_file( self, fname, pos='cursor' ):
        f = open( fname )
	buf = f.read()
        if buf != None and buf != '':
	    self.insert_text( buf, pos )
	    del buf

    def format_paragraph( self, width ):
        import string

	# Move to preferences later
	fill_length = width

	# Get cursor position
	pos = self.text.get_point()
        length = self.text.get_length()

	# Get all the text
	txt = self.text.get_chars(0, length)
        # Clear text widget
        self.text.delete_text(0, -1) 
	
	# Find previous double newline (if any)
	start = string.rfind(txt, '\n\n', 0, pos)
	if start == -1:
	    start = 0
	else:
	    start = start + 2
	
	# Find next double newline (if any)
	end = string.find(txt, '\n\n', pos)
	if end == -1:
	    end = length
	
	# Extract paragraph
	paragraph = txt[start:end]
	
	# Fill paragraph
	paragraph = string.join(string.split(paragraph))
	self.text.insert(None, None, None, txt[:start])
	pos = pos - len(txt[:start])
	
	frozen = 0
	while len(paragraph) > fill_length:
	    # Find word boundary
	    div = string.rfind(paragraph, ' ', 0, fill_length)
	    if div == -1:
		div = 1
                self.text.insert(None, None, None, paragraph[0])
                paragraph = paragraph[div:]
            else:
                self.text.insert(None, None, None, paragraph[:div] + '\n')
                paragraph = paragraph[div+1:]

	    pos = pos - div
	    if not frozen and pos <= 0:
		self.text.freeze()
		frozen = 1
	if not frozen:
	    self.text.freeze()
        self.text.insert(None, None, None, paragraph+txt[end:])
	self.text.thaw()

    def get_text( self ):
	txt = self.text.get_chars(0, self.text.get_length() )
	return( txt )

    def get_length( self ):
	return( self.text.get_length() )
