## $Id: error.py,v 1.2 2001/02/13 14:27:28 kjetilja Exp $

## System modules
from gtk import *
from gnome.ui import *


##
##
## Main error window class
##
##
class ErrorWindow:
    ##
    ## Method __init__ (self, msg)
    ##
    ##    Error widget constructor.
    ##
    ##
    def __init__(self, msg):
        self.win = GnomeDialog(':Pygmy - Runtime Error', 'Dismiss')
        self.vbox = self.win.vbox
        self.win.connect('clicked', self.handle_callbacks)
	self.win.connect('delete_event', self.destroy)
	self.win.connect('destroy', self.destroy)
        self.win.show()
        self.init_window()
        # Populate the window with something sensible
        self.text.insert(None, None, None, msg)
        self.text.get_vadjustment().set_value(0)
        self.vbox.show()

        
    ## Callbacks for the widget
    def handle_callbacks(self, button, no):
        if no == 0:
            self.win.destroy()
            mainquit()

    ## Terminate window
    def destroy(self, b=None, a=None):
        self.win.destroy()
        mainquit()
        

    ##
    ## Method init_window (self)
    ##
    ##    Create main display widget.
    ##
    ##
    def init_window(self):
        self.table = GtkTable(2,2,0)
	self.table.show()
	
	# Error view
	self.text = GtkText()
	self.text.set_editable(0)
	self.text.set_word_wrap(0)
	self.table.attach(self.text,0,1,0,1,xpadding=1,ypadding=1)
        self.text.set_usize(320, 200)
	self.text.show()
	
	# Horizontal scrollbar
	hadj = self.text.get_hadjustment()
	self.hscrollbar = GtkHScrollbar(hadj)
	self.table.attach(self.hscrollbar,0,1,1,2,yoptions=FILL)
	self.hscrollbar.show()
	
	# Vertical scrollbar
	vadj = self.text.get_vadjustment()
	self.vscrollbar = GtkVScrollbar(vadj)
	self.table.attach(self.vscrollbar,1,2,0,1,xoptions=FILL)
	self.vscrollbar.show()
	
	# Pack the widgets together
	self.vbox.pack_start(self.table, expand=TRUE)
